package com.xebialabs.deployit.inspection.service.discovery

import com.google.common.collect.Lists.newArrayList
import com.xebialabs.deployit.engine.api.execution.{StepExecutionState, TaskExecutionState}
import com.xebialabs.deployit.engine.spi.execution.{NonRemotableExecutionStateListener, StepExecutionStateEvent, TaskExecutionStateEvent, Transitions}
import com.xebialabs.deployit.inspection.Inspector
import org.slf4j.LoggerFactory

import scala.jdk.CollectionConverters._

object DiscoveryTrigger {
  private val logger = LoggerFactory.getLogger(classOf[DiscoveryTrigger])
}

class DiscoveryTrigger(val context: DiscoveryContext) extends NonRemotableExecutionStateListener {
  override def stepStateChanged(event: StepExecutionStateEvent): Unit = {
    if (Transitions.checkTransition(event, StepExecutionState.EXECUTING, StepExecutionState.DONE)) {
      DiscoveryTrigger.logger.debug("Checking whether we need to add more steps for recently discovered items.")
      addStepsForDiscoveredItems()
    }
  }

  private def addStepsForDiscoveredItems(): Unit = { // Need to wrap in new list to prevent iteration exception due to call to inspected.
    for (ci <- newArrayList(context.getDiscovered.values).asScala) {
      Inspector.inspect(ci, context)
    }
  }

  override def taskStateChanged(event: TaskExecutionStateEvent): Unit = {
    if (Transitions.checkTransition(event, TaskExecutionState.EXECUTING, TaskExecutionState.EXECUTED)) {
      DiscoveryTrigger.logger.info("Registering inspection results of task [{}]", event.task.getId)
      DiscoveryResults.register(event.task, newArrayList(context.getInspected.values))
    }
  }
}
