package com.xebialabs.deployit.inspection.service.discovery

import java.util

import com.xebialabs.deployit.engine.api.execution.TaskState
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import org.slf4j.LoggerFactory


object DiscoveryResults {
  private val results: util.HashMap[String, DiscoveryResult] = new util.HashMap[String, DiscoveryResult]()

  private[discovery] def register(task: TaskState, result: util.List[ConfigurationItem]): Unit = {
    results.put(task.getId, new DiscoveryResult(task.getId, task.getOwner, result))
  }

  private[discovery] def retrieve(taskId: String) = {
    logger.info("Cleaning discovery results for [{}]", taskId)
    results.remove(taskId)
  }

  private val logger = LoggerFactory.getLogger(classOf[DiscoveryResults])
}

class DiscoveryResults private() {
}
