/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.inspection.service.discovery;

import ai.digital.deploy.tasker.common.TaskType;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.pattern.AskableActorRef$;
import akka.util.Timeout;
import akka.util.Timeout$;
import com.google.common.base.Strings;
import com.xebialabs.deployit.engine.tasker.BlockBuilders$;
import com.xebialabs.deployit.engine.tasker.PhaseContainer;
import com.xebialabs.deployit.engine.tasker.TaskInspectionContext;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.inspection.service.discovery.DiscoveryContext;
import com.xebialabs.deployit.inspection.service.discovery.DiscoveryMessages;
import com.xebialabs.deployit.inspection.service.discovery.DiscoveryResult;
import com.xebialabs.deployit.inspection.service.discovery.DiscoveryResultsRetriever$;
import com.xebialabs.deployit.inspection.service.discovery.DiscoveryTrigger;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.task.TaskMetadataModifier;
import com.xebialabs.deployit.task.WorkdirCleanerTrigger;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000594Aa\u0003\u0007\u00013!A\u0001\u0005\u0001BC\u0002\u0013\u0005\u0011\u0005\u0003\u0005+\u0001\t\u0005\t\u0015!\u0003#\u0011!Y\u0003A!b\u0001\n\u0003a\u0003\u0002\u0003\u0019\u0001\u0005\u0003\u0005\u000b\u0011B\u0017\t\u0011E\u0002!\u0011!Q\u0001\nIBQ!\u000e\u0001\u0005\u0002YBq\u0001\u0010\u0001C\u0002\u0013%A\u0006\u0003\u0004>\u0001\u0001\u0006I!\f\u0005\u0006}\u0001!\ta\u0010\u0005\u00069\u0002!\t!\u0018\u0002\u0011\t&\u001c8m\u001c<fef\u001cVM\u001d<jG\u0016T!!\u0004\b\u0002\u0013\u0011L7oY8wKJL(BA\b\u0011\u0003\u001d\u0019XM\u001d<jG\u0016T!!\u0005\n\u0002\u0015%t7\u000f]3di&|gN\u0003\u0002\u0014)\u0005AA-\u001a9m_fLGO\u0003\u0002\u0016-\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002/\u0005\u00191m\\7\u0004\u0001M\u0011\u0001A\u0007\t\u00037yi\u0011\u0001\b\u0006\u0002;\u0005)1oY1mC&\u0011q\u0004\b\u0002\u0007\u0003:L(+\u001a4\u0002\rML8\u000f^3n+\u0005\u0011\u0003CA\u0012)\u001b\u0005!#BA\u0013'\u0003\u0015\t7\r^8s\u0015\u00059\u0013\u0001B1lW\u0006L!!\u000b\u0013\u0003\u0017\u0005\u001bGo\u001c:TsN$X-\\\u0001\bgf\u001cH/Z7!\u000359xN]6fe6\u000bg.Y4feV\tQ\u0006\u0005\u0002$]%\u0011q\u0006\n\u0002\t\u0003\u000e$xN\u001d*fM\u0006qqo\u001c:lKJl\u0015M\\1hKJ\u0004\u0013aE5o!J|7-Z:t)\u0006\u001c8.\u00128hS:,\u0007CA\u000e4\u0013\t!DDA\u0004C_>dW-\u00198\u0002\rqJg.\u001b;?)\u00119\u0014HO\u001e\u0011\u0005a\u0002Q\"\u0001\u0007\t\u000b\u00012\u0001\u0019\u0001\u0012\t\u000b-2\u0001\u0019A\u0017\t\u000bE2\u0001\u0019\u0001\u001a\u00023\u0011L7oY8wKJL(+Z:vYR\u001c(+\u001a;sS\u00164XM]\u0001\u001bI&\u001c8m\u001c<fef\u0014Vm];miN\u0014V\r\u001e:jKZ,'\u000fI\u0001\u0011aJ,\u0007/\u0019:f\t&\u001c8m\u001c<fef$2\u0001\u0011%U!\t\te)D\u0001C\u0015\t\u0019E)\u0001\u0004uCN\\WM\u001d\u0006\u0003\u000bJ\ta!\u001a8hS:,\u0017BA$C\u0005E!\u0016m]6Ta\u0016\u001c\u0017NZ5dCRLwN\u001c\u0005\u0006\u0013&\u0001\rAS\u0001\u0003G&\u0004\"a\u0013*\u000e\u00031S!!\u0014(\u0002\u0007U$WN\u0003\u0002P!\u0006\u0019\u0011\r]5\u000b\u0005E\u0013\u0012A\u00029mk\u001eLg.\u0003\u0002T\u0019\n\t2i\u001c8gS\u001e,(/\u0019;j_:LE/Z7\t\u000bUK\u0001\u0019\u0001,\u0002\u000f]|'o\u001b#jeB\u0011qKW\u0007\u00021*\u0011\u0011LE\u0001\u000be\u0016\u0004xn]5u_JL\u0018BA.Y\u0005\u001d9vN]6ESJ\f1cZ3u\t&\u001c8m\u001c<fef\u0014Vm];miN$\"AX1\u0011\u0005az\u0016B\u00011\r\u0005=!\u0015n]2pm\u0016\u0014\u0018PU3tk2$\b\"\u00022\u000b\u0001\u0004\u0019\u0017A\u0002;bg.LE\r\u0005\u0002eW:\u0011Q-\u001b\t\u0003Mri\u0011a\u001a\u0006\u0003Qb\ta\u0001\u0010:p_Rt\u0014B\u00016\u001d\u0003\u0019\u0001&/\u001a3fM&\u0011A.\u001c\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005)d\u0002")
public class DiscoveryService {
    private final ActorSystem system;
    private final ActorRef workerManager;
    private final ActorRef discoveryResultsRetriever;

    public ActorSystem system() {
        return this.system;
    }

    public ActorRef workerManager() {
        return this.workerManager;
    }

    private ActorRef discoveryResultsRetriever() {
        return this.discoveryResultsRetriever;
    }

    public TaskSpecification prepareDiscovery(ConfigurationItem ci, WorkDir workDir) {
        DiscoveryContext inspectionContext = new DiscoveryContext();
        inspectionContext.discovered(ci);
        String description = new StringBuilder(14).append("Inspection of ").append(ci.getId()).toString();
        PhaseContainer stepBlock = BlockBuilders$.MODULE$.steps(description, (Option)None$.MODULE$, (List)package$.MODULE$.List().apply((Seq)Nil$.MODULE$)).build();
        TaskSpecification spec = new TaskSpecification(description, Permissions.getAuthentication(), workDir, stepBlock, (TaskInspectionContext)inspectionContext, false);
        spec.getListeners().add(new WorkdirCleanerTrigger(workDir));
        spec.getListeners().add(new DiscoveryTrigger(inspectionContext));
        TaskMetadataModifier.putMetadata((TaskSpecification)spec, (String)"taskType", (String)TaskType.INSPECTION.name());
        return spec;
    }

    public DiscoveryResult getDiscoveryResults(String taskId) {
        Option<DiscoveryResult> option;
        Timeout timeout = Timeout$.MODULE$.apply(10L, TimeUnit.SECONDS);
        try {
            ActorRef qual$1 = akka.pattern.package$.MODULE$.ask(this.discoveryResultsRetriever());
            DiscoveryMessages.RetrieveResults x$1 = new DiscoveryMessages.RetrieveResults(taskId);
            Timeout x$2 = timeout;
            ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
            option = ((DiscoveryMessages.DiscoveryResultsFound)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension(qual$1, (Object)x$1, x$2, x$3), (Duration)timeout.duration())).discoveryResult();
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)"Could not find any results associated with the id [%s]", (Object[])new Object[]{taskId}));
        }
        Option<DiscoveryResult> discoveryResult = option;
        return (DiscoveryResult)discoveryResult.getOrElse((Function0 & Serializable)() -> {
            throw new IllegalArgumentException(Strings.lenientFormat((String)"Could not find any results associated with the id [%s]", (Object[])new Object[]{taskId}));
        });
    }

    public DiscoveryService(ActorSystem system, ActorRef workerManager, boolean inProcessTaskEngine) {
        this.system = system;
        this.workerManager = workerManager;
        this.discoveryResultsRetriever = system.actorOf(DiscoveryResultsRetriever$.MODULE$.props(workerManager, inProcessTaskEngine), DiscoveryResultsRetriever$.MODULE$.name());
    }
}

