package com.xebialabs.deployit.inspection.service.discovery;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.tasker.*;
import com.xebialabs.deployit.inspection.Inspector;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.jdk.javaapi.CollectionConverters;

import java.util.Map;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Preconditions.checkState;
import static com.google.common.collect.Lists.newArrayList;
import static com.google.common.collect.Maps.newHashMap;

@SuppressWarnings("serial")
public class DiscoveryContext implements TaskInspectionContext {
    private Task task;
    private final Map<String, ConfigurationItem> discovered = newHashMap();
    private final Map<String, ConfigurationItem> inspected = newHashMap();

    @Override
    public void registerTask(Task task) {
        this.task = task;
        for (ConfigurationItem configurationItem : newArrayList(discovered.values())) {
            Inspector.inspect(configurationItem, this);
        }
    }

    @Override
    public void discovered(ConfigurationItem item) {
        checkArgument(item.getId() != null, "Discovered configuration item must have an id set.");
        discovered.put(item.getId(), item);
    }

    @Override
    public Map<String, ConfigurationItem> getDiscovered() {
        return discovered;
    }

    @Override
    public void inspected(ConfigurationItem item) {
        if (discovered.remove(item.getId()) == null) {
            logger.warn("{} has been inspected without being discovered", item);
        }
        this.inspected.put(item.getId(), item);
    }

    @Override
    public Map<String, ConfigurationItem> getInspected() {
        return inspected;
    }

    @Override
    public void addStep(Step step) {
        checkState(task != null, "Task is not set.");
        logger.info("Adding discovery step {}", step);
        StepBlock block = task.getBlock().getBlock(BlockPath.apply("1_1")).getOrElse(null);
        block.steps().append(CollectionConverters.asScala(Lists.<StepState>newArrayList(new TaskStep(step))).toSeq());
        logger.info("Block is in [{}] state", block.getState());
    }

    private static final Logger logger = LoggerFactory.getLogger(DiscoveryContext.class);
}
