package com.xebialabs.deployit

import java.util.function.Supplier

import com.xebialabs.deployit.booter.remote.{BooterConfig, DeployitCommunicator, Proxies}
import com.xebialabs.deployit.taskexecution.security.TaskWorkerHttpRequestInterceptor
import com.xebialabs.deployit.taskexecution.xml.TaskExecutionXStreamReaderWriter

class ProxiesSupplier(worker: TaskEngine) extends Supplier[Proxies] {
  private val config: BooterConfig = BooterConfig.builder
    .withProtocol(BooterConfig.Protocol.values()
      .find(p => p.getProtocol.equals(worker.restApi.getProtocol))
      .getOrElse(BooterConfig.Protocol.HTTP))
    .withHost(worker.restApi.getHost)
    .withContext(worker.restApi.getPath)
    .withPort(worker.restApi.getPort)
    .withSocketTimeout(worker.socketTimeout)
    .withXStreamReaderWriter(new TaskExecutionXStreamReaderWriter)
    .withHttpRequestInterceptor(new TaskWorkerHttpRequestInterceptor(worker.address, worker.privateKey))
    .withoutCredentials()
    .build()

  override def get(): Proxies = new DeployitCommunicator(config).getProxies
}
