/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.taskexecution.security;

import com.google.common.collect.Lists;
import com.xebialabs.xlplatform.distribution.RSAUtils;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.RequestLine;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class TaskWorkerHttpRequestInterceptor
implements HttpRequestInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(TaskWorkerHttpRequestInterceptor.class);
    private static final String RSA_SIGNATURE = "rsa";
    private static final String DELIMITER = ":";
    private final RSAKeyParameters privateKey;
    private final String workerId;

    public TaskWorkerHttpRequestInterceptor(String workerId, RSAKeyParameters privateKey) {
        this.privateKey = privateKey;
        this.workerId = workerId;
    }

    public void process(HttpRequest request, HttpContext context) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null) {
            try {
                request.addHeader(this.createRSASignatureHeader(authentication.getName(), request));
            }
            catch (Exception e) {
                logger.error("Unable to add RSA signature {}", (Object)e.getMessage());
            }
        }
    }

    private Header createRSASignatureHeader(String name, HttpRequest request) throws Exception {
        RequestLine requestLine = request.getRequestLine();
        String nonce = UUID.randomUUID().toString().concat(DELIMITER).concat(String.valueOf(System.currentTimeMillis()));
        String message = String.join((CharSequence)DELIMITER, Lists.newArrayList((Object[])new String[]{requestLine.getUri(), requestLine.getMethod(), requestLine.getProtocolVersion().toString(), nonce}));
        String signature = RSAUtils.sign((String)message, (RSAKeyParameters)this.privateKey);
        return new BasicHeader(RSA_SIGNATURE, name.concat(DELIMITER).concat(this.workerId).concat(DELIMITER).concat(nonce).concat(DELIMITER).concat(signature));
    }
}

