package com.xebialabs.deployit.taskexecution.xml;

import com.xebialabs.deployit.booter.remote.xml.TypeProvider;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistryId;
import com.xebialabs.deployit.plugin.api.reflect.Type;

import static com.xebialabs.deployit.booter.local.LocalDescriptorRegistry.LOCAL_ID;

/**
 * Implementation of {@link TypeProvider} to get {@link Type} from the local type system.
 */
public class LocalTypeProvider implements TypeProvider {

    @Override
    public Type getType(final String value) {
        return Type.valueOf(value);
    }

    @Override
    public DescriptorRegistryId getTypeSource() {
        return LOCAL_ID;
    }
}
