package com.xebialabs.deployit.taskexecution.security;

import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;

import java.util.Collection;

public class TaskWorkerAuthenticationToken extends AbstractAuthenticationToken {

    private final String taskOwner;

    TaskWorkerAuthenticationToken(String taskOwner) {
        super(null);
        this.taskOwner = taskOwner;
        setAuthenticated(false);
    }

    TaskWorkerAuthenticationToken(String taskOwner, final Collection<? extends GrantedAuthority> authorities) {
        super(authorities);
        this.taskOwner = taskOwner;
        setAuthenticated(true);
    }

    @Override
    public Object getCredentials() {
        return taskOwner;
    }

    @Override
    public Object getPrincipal() {
        return this.getCredentials();
    }
}
