package com.xebialabs.deployit

import com.xebialabs.deployit.core.events.DeploymentStateEvent
import com.xebialabs.deployit.engine.tasker.RemoteDeploymentStateEventListener
import com.xebialabs.deployit.event.EventBusHolder
import nl.javadude.t2bus.Subscribe
import org.apache.pekko.actor.{ActorSelection, ActorSystem}

class DeploymentStateEventPublisher(system: ActorSystem, masters: Seq[String], hostnameToActorPathTransformer: String => String) {
  EventBusHolder.register(this)

  private val listeners: Seq[ActorSelection] = masters.map(hostnameToActorPathTransformer(_) + "/" + RemoteDeploymentStateEventListener.name).map(system.actorSelection)

  @Subscribe
  def handleDeploymentStateEvent(e: DeploymentStateEvent): Unit = {
    listeners.headOption.getOrElse(throw new NoSuchElementException(s"master list was empty")) ! e
  }
}
