package com.xebialabs.deployit

import com.typesafe.config.{Config, ConfigFactory}
import com.xebialabs.deployit.configuration.CustomProductConfiguration

object TaskEngineProductConfiguration {

  private lazy val launchOptions: TaskEngineLaunchOptions = TaskEngineLaunchOptions.getInstance

  lazy val basicWorkerConfig: Config =
    TaskEngine.configFromOptions(launchOptions)
      .withFallback(
        Option(launchOptions.configFile)
          .map(ConfigFactory.parseFile)
          .getOrElse(ConfigFactory.parseResources("xl-worker.conf")
          )
      )
}

class TaskEngineProductConfiguration extends CustomProductConfiguration {
  override val configuration: Config = TaskEngineProductConfiguration.basicWorkerConfig
}
