package com.xebialabs.deployit.bootstrap

import ai.digital.deploy.task.serdes.TaskAkkaSerializer
import akka.actor.ActorSystem
import com.typesafe.config.Config
import com.xebialabs.deployit.tasksystem.TaskActorSystem
import org.springframework.context.ApplicationContext

import java.io.File

object TaskEngineAkkaBootstrapper {
  def init(config: Config, context: ApplicationContext): ActorSystem = {
    TaskActorSystem.setOverrideConfig(config)
    val system = TaskActorSystem.actorSystem
    val baseWorkDir = new File(context.getBean("baseWorkDir", classOf[String]))
    TaskAkkaSerializer.initExternalWorker(TaskAkkaSerializer.Conf(baseWorkDir), system)
    system
  }
}
