package com.xebialabs.deployit.taskexecution.xml;

import com.google.common.collect.Lists;
import com.thoughtworks.xstream.converters.Converter;
import com.xebialabs.deployit.core.rest.xml.XStreamCiConverterWithRepository;
import com.xebialabs.xltype.serialization.xstream.XStreamReaderWriter;

import java.util.List;

public class TaskExecutionXStreamReaderWriter extends XStreamReaderWriter {

    private static final List<String> blacklistClasses = Lists.newArrayList(
            "com.xebialabs.deployit.booter.remote.xml.RemoteXStreamCiConverter",
            "com.xebialabs.deployit.booter.remote.xml.TaskConverterSelector",
            "com.xebialabs.deployit.booter.remote.xml.DescriptorConverter",
            "com.xebialabs.deployit.booter.remote.xml.PropertyDescriptorConverter",
            "com.xebialabs.deployit.booter.remote.xml.MethodDescriptorConverter",
            "com.xebialabs.deployit.core.rest.xml.TaskSelectorWriter",
            "com.xebialabs.deployit.core.rest.xml.BlockStateWriter",
            "com.xebialabs.deployit.core.rest.xml.DescriptorWriter"
    );

    public TaskExecutionXStreamReaderWriter() {
        XStreamReaderWriter.registerConfigurationItemAliases();
        registerConverter(new XStreamCiConverterWithRepository(null));
    }

    @Override
    protected Converter constructConverter(final Class<?> clazz) {
        if (blacklistClasses.contains(clazz.getName())) {
            return null;
        }
        return super.constructConverter(clazz);
    }
}
