package com.xebialabs.deployit.bootstrap

import akka.actor.ActorSystem
import akka.serialization.SerializationExtension
import com.esotericsoftware.kryo.Kryo
import com.typesafe.config.Config
import com.xebialabs.deployit.engine.tasker.satellite.WorkDirSerializer
import com.xebialabs.deployit.repository.WorkDir
import com.xebialabs.deployit.tasksystem.TaskActorSystem
import io.altoo.akka.serialization.kryo.KryoAkkaSerializer
import org.springframework.context.ApplicationContext

import java.io.File

object TaskEngineAkkaBootstrapper {
  def init(config: Config, context: ApplicationContext): ActorSystem = {
    TaskActorSystem.setOverrideConfig(config)
    val system = TaskActorSystem.actorSystem
    val baseWorkDir = new File(context.getBean("baseWorkDir", classOf[String]))
    SerializationExtension(system).serializerFor(classOf[WorkDir]).asInstanceOf[KryoAkkaSerializer].setKryoCustomizers(
      (kryo: Kryo) => kryo.addDefaultSerializer(classOf[WorkDir], new WorkDirSerializer(kryo, baseWorkDir, true))
    )
    system
  }
}
