package com.xebialabs.deployit.config

import com.typesafe.config.{Config, ConfigFactory}
import com.xebialabs.deployit.hocon.HoconConfigLoader
import com.xebialabs.deployit.{TaskEngine, TaskEngineLaunchOptions}
import com.xebialabs.deployit.security.SecretKeyHolder
import com.xebialabs.deployit.tasksystem.ConfigLoading
import com.xebialabs.xlplatform.config.ConfigLoader
import org.springframework.core.io.Resource

class TaskEngineHoconConfigLoader(val options: TaskEngineLaunchOptions) extends HoconConfigLoader {

  override def loadBasicConfig(resource: Resource): Config = {
    val basicConfig: Config = super.loadBasicConfig(resource)
    basicWorkerConfig.withFallback(basicConfig)
  }

  override def loadConfig(resource: Resource): Config = {
    val resourceFilename = resource.getFilename
    val basicConfig: Config = ConfigFactory.parseResources(resourceFilename)

    val config: Config = ConfigLoader.loadSecuredWithDynamic(
      configResource = resourceFilename,
      keyHolder = SecretKeyHolder.get(),
      defaultReference =
        ConfigLoading.loadConfig(basicWorkerConfig.withFallback(basicConfig)))

    ConfigLoading.loadConfig(basicWorkerConfig.withFallback(config))
  }

  private lazy val basicWorkerConfig =
    TaskEngine.configFromOptions(options)
      .withFallback(Option(options.configFile)
        .map(ConfigFactory.parseFile)
        .getOrElse(ConfigFactory.parseResources("xl-worker.conf")
        ))
}
