package com.xebialabs.deployit

import ai.digital.configuration.central.deploy.{ServerSideProperties, TaskerSystemProperties}
import com.typesafe.config.Config
import com.xebialabs.deployit.TaskExecutionEngineBootstrapper.serverConfig
import com.xebialabs.deployit.booter.local.{GlobalContextManager, LocalBooter}
import com.xebialabs.deployit.booter.remote.Proxies
import com.xebialabs.deployit.core.config.{SqlConfiguration, XldSpringConfig}
import com.xebialabs.deployit.core.ordering.ConfigurationItemIdComparator
import com.xebialabs.deployit.core.rest.api._
import com.xebialabs.deployit.core.rest.util.RepositoryHelper
import com.xebialabs.deployit.core.sql.SchemaInfo
import com.xebialabs.deployit.engine.api._
import com.xebialabs.deployit.engine.tasker.repository.sql.{SqlActiveTaskRepository, SqlPendingTaskRepository, SqlWorkerRepository}
import com.xebialabs.deployit.event.EventBusHolder
import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.repository.sql.SqlRepositoryMetadataService
import com.xebialabs.deployit.script.SpringBindings
import com.xebialabs.deployit.service.coc.DefaultSCMTraceabilityService
import com.xebialabs.deployit.service.deployment.TypeCalculator
import com.xebialabs.deployit.service.externalproperties.ExternalValueProvider
import com.xebialabs.deployit.service.lookup.ExternalPropertyLookupValueProvider
import com.xebialabs.deployit.service.validation.Validator
import com.xebialabs.deployit.task.archive.queue.AsyncTaskArchiveProducer
import com.xebialabs.deployit.task.archive.sql.SqlTaskArchive
import com.xebialabs.deployit.util.PasswordEncrypter
import com.xebialabs.plugin.classloader.PluginClassLoader
import com.xebialabs.plugin.manager.materializer.PluginsMaterializer
import com.xebialabs.xldeploy.jms.adapter.DefaultQueueJmsBean
import com.xebialabs.xlplatform.coc.service.SCMTraceabilityService
import com.xebialabs.xlplatform.config.ConfigurationHolder
import org.springframework.beans.factory.annotation.{Autowired, Qualifier, Value}
import org.springframework.context.annotation._
import org.springframework.core.env.ConfigurableEnvironment
import org.springframework.jdbc.core.JdbcTemplate

import javax.annotation.PostConstruct


@Configuration
@ComponentScan(value = Array(
  "com.xebialabs.deployit.checksum",
  "com.xebialabs.deployit.config",
  "com.xebialabs.deployit.core.config",
  "com.xebialabs.deployit.core.defaults",
  "com.xebialabs.deployit.core.ordering",
  "com.xebialabs.deployit.core.server.service",
  "com.xebialabs.deployit.security.archive.sql",
  "com.xebialabs.deployit.security.service",
  "com.xebialabs.deployit.security.sql",
  "com.xebialabs.deployit.repository",
  "com.xebialabs.xlplatform.config",
  "com.xebialabs.deployit.booter.local",
),
  excludeFilters = Array(
    new ComponentScan.Filter(`type` = FilterType.REGEX,
      pattern = Array(
        "com.xebialabs.deployit.core.config.session.*",
        "com.xebialabs.deployit.core.config.DeployedPropertySetterConfig",
        "com.xebialabs.deployit.core.config.XldConfig",
      ))
  ))
@Import(
  Array(
    classOf[SqlConfiguration],
    classOf[AsyncTaskArchiveProducer],
    classOf[DefaultQueueJmsBean],
    classOf[MetadataResource],
    classOf[PermissionResource],
    classOf[ServicesConfig],
    classOf[SpringBindings],
    classOf[SqlActiveTaskRepository],
    classOf[SqlPendingTaskRepository],
    classOf[SqlRepositoryMetadataService],
    classOf[SqlTaskArchive],
    classOf[SqlWorkerRepository],
    classOf[TaskerSystemProperties],
    classOf[TypeCalculator],
    classOf[UserResource],
    classOf[Validator],
    classOf[XldSpringConfig],
    classOf[ServerSideProperties]
  )
)
class TaskEngineConfig {

  @Autowired
  var environment: ConfigurableEnvironment = _

  @Value("${deploy.task.recovery-dir:work}")
  var recoveryDir: String = _

  @Bean def baseWorkDir: String = recoveryDir

  @Bean def serverConfiguration: ServerConfiguration = serverConfig

  @Bean def proxies: Proxies = new ProxiesSupplier(TaskEngine.getInstance).get()

  @Bean
  def passwordEncrypter: PasswordEncrypter = PasswordEncrypter.getInstance()

  @Bean
  def externalValueProvider(repositoryService: repository.RepositoryService): ExternalValueProvider =
    new ExternalPropertyLookupValueProvider(repositoryService)

  @Bean
  def configurationHolderInitilizer(): Config = {
    ConfigurationHolder.get()
  }

  @Bean
  @Autowired
  def defaultSCMTraceabilityService(@Qualifier("mainJdbcTemplate") jdbcTemplate: JdbcTemplate,
                                    @Qualifier("mainSchema") mainSchemaInfo: SchemaInfo): SCMTraceabilityService =
    new DefaultSCMTraceabilityService(jdbcTemplate)(mainSchemaInfo)

  @Bean
  @Autowired
  def serviceHolder(proxies: Proxies,
                    metadataService: MetadataService,
                    permissionService: PermissionService,
                    repositoryService: RepositoryService,
                    roleService: RoleService,
                    userService: UserService): ServiceHolder =
    new ServiceHolder(
      proxies.getControlService,
      proxies.getDeploymentService,
      proxies.getInspectionService,
      metadataService,
      proxies.getPackageService,
      permissionService,
      repositoryService,
      roleService,
      proxies.getServerService,
      proxies.getTaskService,
      proxies.getTaskBlockService,
      userService,
      null, // TODO Discuss whether this should be exposed
      proxies.getReportService
    )

  @Autowired
  var globalContextManager: GlobalContextManager = _

  @Autowired
  var pluginsMaterializer: PluginsMaterializer = _

  @PostConstruct
  def materializePluginsAndInitializeTypeSystem(): Unit = {
    materializePlugins()
    LocalBooter.boot(XldServerPaths.TYPE_DEFAULTS, globalContextManager)
  }

  private def materializePlugins(): Unit = {
    Thread.currentThread.getContextClassLoader match {
      case pluginClassLoader: PluginClassLoader =>
        pluginClassLoader.clearClasspathRoots()
        pluginsMaterializer.materializePlugins()
        pluginClassLoader.refreshDirs()
      case _ =>
    }
  }
}

@ComponentScan(
  Array("com.xebialabs.deployit.security",
    "com.xebialabs.deployit.core.ordering",
    "com.xebialabs.deployit.service.externalproperties")
)
@Import(
  Array(classOf[DeployitRepositoryResource],
    classOf[RoleResource],
    classOf[ConfigurationItemIdComparator],
    classOf[EventBusHolder])
)
class ServicesConfig {

  import com.xebialabs.deployit.repository.RepositoryService

  @Bean
  @Autowired
  def repositoryHelper(repositoryService: RepositoryService, roleService: RoleService): RepositoryHelper =
    new RepositoryHelper(
      repositoryService,
      roleService,
      java.util.Arrays.asList(Type.valueOf("overthere.RemoteHost"))
    )
}
