package com.xebialabs.deployit

import java.io.File
import java.net.URL

import org.kohsuke.args4j.spi.StringArrayOptionHandler
import org.kohsuke.args4j.{Option => CmdLineOption}

object TaskEngineLaunchOptions {
  private var instance: TaskEngineLaunchOptions = _

  def setInstance(launchOptions: TaskEngineLaunchOptions): Unit = {
    instance = launchOptions
  }

  def getInstance: TaskEngineLaunchOptions = instance
}

class TaskEngineLaunchOptions {

  @CmdLineOption(name = "-hostname", usage = "The hostname of this worker (must be resolvable by the master) (defaults to hostname of localhost)", metaVar = "NAME")
  var hostname: String = _

  @CmdLineOption(name = "-port", usage = "The remoting port of this worker (default: 8180)")
  var port: Integer = _

  @CmdLineOption(name = "-master", usage = "The remoting endpoint of master (hostname:port) (e.g. master:8180)", required = true, metaVar = "NAME:PORT", handler = classOf[StringArrayOptionHandler])
  var masters: Array[String] = _

  @CmdLineOption(name = "-api", usage = "The HTTP endpoint of the master as a url (e.g. https://master:4516)", required = true)
  var api: URL = _

  @CmdLineOption(name = "-work", usage = "The work folder to use for this worker", metaVar = "FOLDER")
  var workDir: String = _

  @CmdLineOption(name = "-config", usage = "Additional HOCON config file for the worker")
  var configFile: File = _

  @CmdLineOption(name = "-name", usage = "The name of this worker to identify it in UI (defaults to hostname:port)", metaVar = "NAME")
  var name: String = _

  @CmdLineOption(name = "-socketTimeout", usage = "The timeout (in ms) for execution of API call (default: 120000)", metaVar = "SOCKET_TIMEOUT")
  var socketTimeout: Integer = 120000

}
