package com.xebialabs.deployit.task.archive;

import com.xebialabs.deployit.engine.api.execution.BlockState;
import com.xebialabs.deployit.engine.api.execution.PhaseState;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.tasker.Block;
import com.xebialabs.deployit.engine.tasker.BlockPath;
import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Seq;

import java.util.List;

public class ArchivedPhase extends ArchivedAbstractBlock implements PhaseState {

    public final ArchivedAbstractBlock underlyingBlock;

    public ArchivedPhase(ArchivedAbstractBlock underlyingBlock) {
        this.underlyingBlock = underlyingBlock;
    }

    @Override
    public List<StepState> getStepList() {
        return underlyingBlock.getStepList();
    }

    @Override
    public StepState getStep(BlockPath path) {
        return underlyingBlock.getStep(path.tail());
    }

    @Override
    public scala.Option<Block> getBlock(BlockPath path) {
        if (path.isEmpty()) {
            return Option.apply(this);
        }
        return underlyingBlock.getBlock(path.tail());
    }

    @Override
    public Seq<Tuple2<BlockPath, StepState>> getStepsWithPaths() {
        return underlyingBlock.getStepsWithPaths();
    }

    @Override
    public BlockState getBlock() {
        return underlyingBlock;
    }
}
