package com.xebialabs.deployit.task.archive

import com.xebialabs.deployit.engine.api.execution.{StepExecutionState, StepState}
import org.joda.time.DateTime

import java.util

class ArchivedStep extends StepState {
  private var description: String = _
  private var state: StepExecutionState = _
  private var log: String = _
  private var prevLogs: util.List[String] = _
  private var startDate: DateTime = _
  private var completionDate: DateTime = _
  private var failureCount = 0
  private var metadata: util.Map[String, String] = new util.HashMap[String, String]

  override def getDescription: String = description

  override def getState: StepExecutionState = state

  override def getLog: String = log

  override def getPreviousAttemptsLogs: util.List[String] = prevLogs

  override def getStartDate: DateTime = startDate

  override def getCompletionDate: DateTime = completionDate

  override def getFailureCount: Int = failureCount

  override def getMetadata: util.Map[String, String] = metadata

  override def getSkippable: Boolean = false

  def setDescription(description: String): Unit = this.description = description

  def setState(state: StepExecutionState): Unit = this.state = state

  def setLog(log: String): Unit = this.log = log

  def setPreviousAttemptsLogs(logs: util.List[String]): Unit = this.prevLogs = logs

  def setStartDate(startDate: DateTime): Unit = this.startDate = startDate

  def setCompletionDate(completionDate: DateTime): Unit = this.completionDate = completionDate

  def setFailureCount(failureCount: Int): Unit = this.failureCount = failureCount

  def setMetadata(metadata: util.Map[String, String]): Unit = this.metadata = metadata
}
