package com.xebialabs.deployit.task

import java.util

import com.fasterxml.jackson.annotation._
import com.fasterxml.jackson.databind.annotation.{JsonDeserialize, JsonSerialize}
import com.xebialabs.deployit.engine.api.execution._
import com.xebialabs.deployit.engine.tasker.{Block, Phase, PhaseContainer}
import com.xebialabs.deployit.task.archive._

package object archive {
  def patchPhaseContainer(task: ArchivedTask): ArchivedTask = {
    task.getBlock match {
      case _: ArchivedPhaseContainer => // Do nothing
      case b: ArchivedAbstractBlock =>
        val phase = new ArchivedPhase(b)

        phase.setState(BlockExecutionState.STOPPED)
        phase.setDescription("phase1")
        val container = new ArchivedPhaseContainer(java.util.Arrays.asList(phase))
        container.setState(BlockExecutionState.STOPPED)
        container.setDescription("")

        task.setBlock(container)
      case _ => // Do nothing
    }
    task
  }
}

@JsonSerialize(as=classOf[TaskWithBlock])
@JsonIgnoreProperties(Array("workerId"))
trait TaskWithBlockMixin extends TaskWithBlock

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property = "type")
@JsonSubTypes(Array(
  new JsonSubTypes.Type(value=classOf[ArchivedPhaseContainer], name="PhaseContainer"),
  new JsonSubTypes.Type(value=classOf[ArchivedPhase], name="Phase"),
  new JsonSubTypes.Type(value=classOf[ArchivedStepBlock], name="StepBlock"),
  new JsonSubTypes.Type(value=classOf[ArchivedCompositeBlock], name="SerialBlock"),
  new JsonSubTypes.Type(value=classOf[ArchivedCompositeBlock], name="ParallelBlock")
))
trait BlockStateMixin extends BlockState

@JsonIgnoreProperties(Array("blocks", "phasesState", "stepList", "stepsWithPaths"))
trait PhaseContainerMixin extends PhaseContainer

@JsonIgnoreProperties(Array("blocks", "phasesState", "stepList", "stepsWithPaths"))
@JsonCreator
abstract class ArchivedPhaseContainerMixin(@JsonProperty("phases") phases: util.List[ArchivedPhase]) extends ArchivedPhaseContainer(phases)

@JsonIgnoreProperties(Array("stepList", "stepsWithPaths"))
trait PhaseMixin extends Phase

@JsonIgnoreProperties(Array("stepList", "stepsWithPaths", "underlyingBlock"))
@JsonCreator
abstract class ArchivedPhaseMixin(@JsonProperty("block") underlyingBlock: ArchivedAbstractBlock) extends ArchivedPhase(underlyingBlock)

@JsonIgnoreProperties(Array("currentStep", "stepList", "stepsWithPaths"))
trait ExecutableBlockMixin extends Block

@JsonIgnoreProperties(Array("failed", "implementation", "lastModificationDate", "markedForSkip", "skippable"))
@JsonDeserialize(as=classOf[ArchivedStep])
trait StepStateMixin extends StepState

@JsonCreator
abstract class TaskPackageDependencyMixin(@JsonProperty("application") application: String, @JsonProperty("version") version: String) extends TaskPackageDependency(application, version)
