package com.xebialabs.deployit.task.archive

import com.xebialabs.deployit.booter.local.TypePluginMappingManager

import scala.util.matching.Regex

object PluginUtils {
  private def getPluginURL(ciType: String): String = {
    TypePluginMappingManager.getPluginUrl(ciType)
  }

  private def getPluginNameFromUrl(url: String): Option[String] = {
    if (url != null) {
      val values: List[String] = url.split("/").filter((s: String) => s.contains(".xldp") || s.contains(".jar")).toList
      return values.headOption.map(_.replaceAll("\\.xldp!?|\\.jar!?$", ""))
    }
    None
  }

    private def getPluginNameWithVersion(url: String): (Option[String], Option[String]) = {
      val pluginNameWithVersion = getPluginNameFromUrl(url)
      splitPluginName(pluginNameWithVersion)
    }

    private def  splitPluginName(pluginNameWithVersion: Option[String]): (Option[String], Option[String]) = {
      val versionPattern: Regex = "^\\d+\\.\\d+\\.\\d+([a-zA-Z0-9.-]*)$".r

      pluginNameWithVersion match {
        case Some(pluginNameWithVersion) if !pluginNameWithVersion.isEmpty =>
          val parts = pluginNameWithVersion.split("(?=\\d)", 2)
          var pluginName = pluginNameWithVersion
          var version: Option[String] = None
          if (parts.length > 1) {
            if (versionPattern.matches(parts(1))) {
              pluginName = parts(0).trim.substring(0, parts(0).length - 1)
              version = Some(parts(1).trim)
            }
          }
          (Option(pluginName), version)
        case _ => (None, None)
      }
    }

  private def getPluginType(url: Option[String]): Option[String] = url match {
    case Some(s) if s.contains("xld-official") => Option("official")
    case Some(s) if s.contains("__local__") => Option("custom")
    case _ => None
  }

  def createPluginData(ciType: String): PluginData = {
      val pluginUrl = getPluginURL(ciType)
      val (pluginName, pluginVersion) = getPluginNameWithVersion(pluginUrl)
      PluginData(pluginName, pluginVersion, getPluginType(Option(pluginUrl)))
  }

  case class PluginData(pluginName: Option[String], pluginVersion: Option[String], pluginType: Option[String])

}
