package com.xebialabs.deployit.task.archive

import com.xebialabs.deployit.engine.api.execution.TaskWithBlock
import org.joda.time.DateTime

class DefaultTaskArchiveSerializer(val task: TaskWithBlock) extends TaskSerlializer {
  def getTaskKind: String = DefaultTaskArchiveSerializer.kind

  override def serialize(workerName: Option[String]): TaskMessage =
    DefaultTaskMessage(task.getId, archiveDetails(workerName), task.getStartDate)

  protected def archiveDetails(workerName: Option[String]): ArchiveDetails =
    ArchiveDetails(getTaskKind, workerName, ArchiveObjectMapper.mapper.writeValueAsString(task))
}

case class DefaultTaskMessage(override val taskId: String,
                              override val archiveDetails: ArchiveDetails,
                              override val startDate: DateTime) extends TaskMessage

object DefaultTaskArchiveSerializer {
  val kind = "UNKNOWN"
}
