package com.xebialabs.deployit.task.archive;

import com.xebialabs.deployit.engine.api.execution.PhaseContainerState;
import com.xebialabs.deployit.engine.api.execution.PhaseState;
import com.xebialabs.deployit.engine.api.execution.SatelliteConnectionState;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.tasker.Block;
import com.xebialabs.deployit.engine.tasker.BlockPath;
import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;

import java.util.List;
import java.util.stream.Collectors;

import static com.google.common.collect.FluentIterable.from;

public class ArchivedPhaseContainer extends ArchivedAbstractBlock implements PhaseContainerState, Block {

    public final List<ArchivedPhase> phases;

    public ArchivedPhaseContainer(List<ArchivedPhase> phases) {
        this.phases = phases;
    }

    @Override
    public List<StepState> getStepList() {
        return from(phases).transformAndConcat(ArchivedPhase::getStepList).toList();
    }

    @Override
    public StepState getStep(BlockPath path) {
        int head = path.head();
        return (phases.get(head - 1)).getStep(path.tail());

    }

    @Override
    public Option<Block> getBlock(BlockPath path) {
        if (path.isEmpty()) {
            return Option.apply(this);
        }
        int head = path.head();
        return phases.get(head - 1).getBlock(path.tail());
    }

    @Override
    public Seq<Tuple2<BlockPath, StepState>> getStepsWithPaths() {
        ListBuffer<Tuple2<BlockPath, StepState>> swp = new ListBuffer<>();
        for (ArchivedPhase phase : phases) {
            swp.appendAll(phase.getStepsWithPaths());
        }
        return swp.toSeq();
    }

    @Override
    public Iterable<PhaseState> getBlocks() {
        return phases.stream().map((ArchivedPhase input) -> (PhaseState) input).collect(Collectors.toList());
    }

    @Override
    public void satelliteState_$eq(SatelliteConnectionState satelliteConnectionState) {
        setSatelliteState(satelliteConnectionState);
    }
}
