/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.task;

import ai.digital.deploy.tasker.common.TaskType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.util.CiUtils;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.api.execution.FetchMode;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.task.FilterType;
import com.xebialabs.deployit.util.Tuple;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class ArchivedTaskSearchParameters {
    protected DateTime startDate;
    protected DateTime endDate;
    protected String executedBy;
    protected Set<String> users = Sets.newHashSet();
    protected Set<Application> applications = Sets.newHashSet();
    protected Set<String> environments = Sets.newHashSet();
    protected String taskUuid;
    protected DateRange dateRangeSearch = DateRange.NONE;
    protected Status status = Status.ANY;
    protected Set<TaskExecutionState> taskExecutionStates = EnumSet.noneOf(TaskExecutionState.class);
    protected Set<TaskType> taskTypes = EnumSet.noneOf(TaskType.class);
    protected List<Tuple<String, Boolean>> orderBy = new ArrayList<Tuple<String, Boolean>>();
    protected int page;
    protected int resultsPerPage;
    protected boolean onlySuccessful;
    protected FetchMode fetchMode;
    protected Set<String> targets;
    protected String taskName;
    protected String workerName;
    protected List<String> references;
    protected boolean filterByArchivedDate;

    public ArchivedTaskSearchParameters() {
        this.filterByArchivedDate = false;
    }

    public ArchivedTaskSearchParameters(ArchivedTaskSearchParameters p) {
        this.startDate = p.startDate;
        this.endDate = p.endDate;
        this.executedBy = p.executedBy;
        this.applications = Sets.newHashSet(p.applications);
        this.environments = Sets.newHashSet(p.environments);
        this.dateRangeSearch = p.dateRangeSearch;
        this.status = p.status;
        this.taskExecutionStates = p.taskExecutionStates;
        this.taskUuid = p.taskUuid;
        this.taskTypes = p.taskTypes;
        this.orderBy.addAll(p.orderBy);
        this.page = p.page;
        this.resultsPerPage = p.resultsPerPage;
        this.users = p.users;
        this.onlySuccessful = p.onlySuccessful;
        this.fetchMode = p.fetchMode;
        this.targets = p.targets;
        this.taskName = p.taskName;
        this.workerName = p.workerName;
        this.references = p.references;
        this.filterByArchivedDate = p.filterByArchivedDate;
    }

    public ArchivedTaskSearchParameters orderBy(String property, boolean ascending) {
        this.orderBy.add((Tuple<String, Boolean>)new Tuple((Object)property, (Object)ascending));
        return this;
    }

    public ArchivedTaskSearchParameters executedByUser(String user) {
        this.executedBy = user;
        return this;
    }

    public ArchivedTaskSearchParameters createdBetween(DateTime startDate, DateTime endDate) {
        Checks.checkNotNull((Object)startDate, (String)"Start date cannot be null");
        Checks.checkNotNull((Object)endDate, (String)"End date cannot be null");
        this.dateRangeSearch = DateRange.BETWEEN;
        if (startDate.isAfter((ReadableInstant)endDate)) {
            this.startDate = endDate;
            this.endDate = startDate;
        } else {
            this.startDate = startDate;
            this.endDate = endDate;
        }
        return this;
    }

    public ArchivedTaskSearchParameters createdOnOrBefore(DateTime endDate) {
        Checks.checkNotNull((Object)endDate, (String)"End date cannot be null");
        this.dateRangeSearch = DateRange.BEFORE;
        this.endDate = endDate;
        return this;
    }

    public ArchivedTaskSearchParameters createdOnOrAfter(DateTime startDate) {
        Checks.checkNotNull((Object)startDate, (String)"Start date cannot be null");
        this.dateRangeSearch = DateRange.AFTER;
        this.startDate = startDate;
        return this;
    }

    public ArchivedTaskSearchParameters inDateTimeRange(DateTime startDate, DateTime endDate) {
        if (startDate == null && endDate == null) {
            return this;
        }
        if (startDate == null) {
            return this.createdOnOrBefore(endDate);
        }
        if (endDate == null) {
            return this.createdOnOrAfter(startDate);
        }
        return this.createdBetween(startDate, endDate);
    }

    public ArchivedTaskSearchParameters forApplicationAndVersion(String application, String version) {
        this.applications.add(new Application(application, version));
        return this;
    }

    public ArchivedTaskSearchParameters forApplication(String application) {
        return this.forApplicationAndVersion(application, null);
    }

    public ArchivedTaskSearchParameters thatAreOfType(Set<TaskType> types) {
        this.taskTypes = types;
        return this;
    }

    public ArchivedTaskSearchParameters forEnvironment(String environment) {
        this.environments.add(environment);
        return this;
    }

    public ArchivedTaskSearchParameters forFilterType(FilterType filterType, List<ConfigurationItemId> cis) {
        for (ConfigurationItemId appOrEnvName : cis) {
            this.forFilterType(filterType, appOrEnvName);
        }
        return this;
    }

    public ArchivedTaskSearchParameters forFilterType(FilterType filterType, ConfigurationItemId appOrEnvName) {
        switch (filterType) {
            case APPLICATION: {
                Checks.checkTrue((boolean)this.environments.isEmpty(), (String)"Can't query for both environments and applications without FilterType.BOTH.", (Object[])new Object[0]);
                this.forApplication(CiUtils.getName((String)appOrEnvName.getId()));
                break;
            }
            case ENVIRONMENT: {
                Checks.checkTrue((boolean)this.applications.isEmpty(), (String)"Can't query for both environments and applications without FilterType.BOTH.", (Object[])new Object[0]);
                this.forEnvironment(appOrEnvName.getId());
                break;
            }
            case BOTH: {
                Type application = Type.valueOf((String)"udm.Application");
                if (appOrEnvName.getType().equals((Object)application) || appOrEnvName.getType().isSubTypeOf(application)) {
                    this.forApplication(CiUtils.getName((String)appOrEnvName.getId()));
                    break;
                }
                this.forEnvironment(appOrEnvName.getId());
                break;
            }
        }
        return this;
    }

    public ArchivedTaskSearchParameters withTaskStates(List<String> states) {
        for (String state : states) {
            this.taskExecutionStates.add(TaskExecutionState.valueOf((String)state.toUpperCase()));
        }
        return this;
    }

    public ArchivedTaskSearchParameters thatWasCancelled() {
        this.status = Status.CANCELLED;
        return this;
    }

    public ArchivedTaskSearchParameters thatCompleted() {
        this.status = Status.COMPLETED;
        return this;
    }

    public ArchivedTaskSearchParameters thatCompletedAfterRetry() {
        this.status = Status.COMPLETED_AFTER_RETRY;
        return this;
    }

    public ArchivedTaskSearchParameters withUniqueId(String uuid) {
        this.taskUuid = uuid;
        return this;
    }

    public ArchivedTaskSearchParameters showPage(int page, int resultsPerPage) {
        this.page = page;
        this.resultsPerPage = resultsPerPage;
        return this;
    }

    public ArchivedTaskSearchParameters forTaskTypes(Set<TaskType> taskTypes) {
        this.taskTypes = taskTypes;
        return this;
    }

    public ArchivedTaskSearchParameters forUsers(Set<String> users) {
        this.users = users;
        return this;
    }

    public ArchivedTaskSearchParameters forSuccessfulOnly(boolean onlySuccessful) {
        this.onlySuccessful = onlySuccessful;
        return this;
    }

    public ArchivedTaskSearchParameters withFetchMode(FetchMode fetchMode) {
        this.fetchMode = fetchMode;
        return this;
    }

    public ArchivedTaskSearchParameters withTargets(Set<String> targets) {
        this.targets = targets;
        return this;
    }

    public ArchivedTaskSearchParameters withTaskName(String taskName) {
        this.taskName = taskName;
        return this;
    }

    public ArchivedTaskSearchParameters withWorkerName(String workerName) {
        this.workerName = workerName;
        return this;
    }

    public ArchivedTaskSearchParameters applySecurityParameters(List<String> references) {
        this.references = references;
        return this;
    }

    public ArchivedTaskSearchParameters setFilterByArchivedDate(boolean filterByArchivedDate) {
        this.filterByArchivedDate = filterByArchivedDate;
        return this;
    }

    public FetchMode getFetchMode() {
        return this.fetchMode;
    }

    @VisibleForTesting
    public Set<TaskType> getTaskTypes() {
        return this.taskTypes;
    }

    @VisibleForTesting
    public DateTime getStartDate() {
        return this.startDate;
    }

    @VisibleForTesting
    public DateTime getEndDate() {
        return this.endDate;
    }

    @VisibleForTesting
    public List<Tuple<String, Boolean>> getOrderBy() {
        return this.orderBy;
    }

    @VisibleForTesting
    public int getPage() {
        return this.page;
    }

    @VisibleForTesting
    public int getResultsPerPage() {
        return this.resultsPerPage;
    }

    @VisibleForTesting
    public String getTaskUuid() {
        return this.taskUuid;
    }

    @VisibleForTesting
    public boolean isOnlySuccessful() {
        return this.onlySuccessful;
    }

    @VisibleForTesting
    public Set<String> getUsers() {
        return this.users;
    }

    @VisibleForTesting
    public Set<Application> getApplications() {
        return this.applications;
    }

    @VisibleForTesting
    public Set<String> getEnvironments() {
        return this.environments;
    }

    @VisibleForTesting
    public Set<TaskExecutionState> getTaskExecutionStates() {
        return this.taskExecutionStates;
    }

    @VisibleForTesting
    public Set<String> getTargets() {
        return this.targets;
    }

    @VisibleForTesting
    public String getTaskName() {
        return this.taskName;
    }

    public boolean hasSecurityParameters() {
        return this.references != null;
    }

    public boolean isFilterByArchivedDate() {
        return this.filterByArchivedDate;
    }

    public static class Application {
        public final String name;
        public final String version;

        Application(String name, String version) {
            this.name = name;
            this.version = version;
        }
    }

    public static enum Status {
        COMPLETED,
        CANCELLED,
        COMPLETED_AFTER_RETRY,
        ANY;

    }

    public static enum DateRange {
        AFTER,
        BEFORE,
        BETWEEN,
        NONE;

    }
}

