package com.xebialabs.deployit.task;

import com.xebialabs.deployit.engine.api.execution.SerializableTask;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.task.archive.ArchivedTask;

public final class TaskMetadataModifier {

    private TaskMetadataModifier() {
    }

    public static void putMetadata(ArchivedTask task, String property, String value) {
        task.getMetadata().put(property, value);
    }

    public static void putMetadata(TaskSpecification task, String property, String value) {
        task.getMetadata().put(property, value);
    }

    public static String getMetadata(SerializableTask task, String property) {
        return task.getMetadata().get(property);
    }

    public static String getMetadata(TaskSpecification task, String property) {
        return task.getMetadata().get(property);
    }

    public static boolean metadataContainsKey(SerializableTask task, String property) {
        return task.getMetadata().containsKey(property);
    }

}
