package com.xebialabs.deployit.task.archive.queue

import com.xebialabs.deployit.task.archive.TaskArchiveQueue
import com.xebialabs.deployit.task.archive.compression.CompressionUtils
import com.xebialabs.xldeploy.jms.adapter.ArchiveQueueNameResolver
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.{Autowired, Qualifier}
import org.springframework.jms.core.JmsTemplate
import org.springframework.jms.support.converter.MessageConverter
import org.springframework.stereotype.Service

import java.util
import javax.jms.{QueueBrowser, Session, TextMessage}

@Service
@Autowired
class TaskArchiveQueueRetriever(@Qualifier("mainJmsTemplate") jmsTemplate: JmsTemplate,
                                jacksonJmsMessageConverter: MessageConverter,
                                archiveQueueNameResolver: ArchiveQueueNameResolver) extends TaskArchiveQueue with Logging {
  override def getTaskDetails(taskId: String): Option[String] = {
    jmsTemplate.browse(archiveQueueNameResolver.getQueueName,
      (_: Session, browser: QueueBrowser) => {
        val messages: util.Enumeration[_] = browser.getEnumeration
        while(messages.hasMoreElements) {
          messages.nextElement() match {
            case m: TextMessage =>
              if (taskId == m.getStringProperty(ArchiveTaskQueueing.ArchivedTaskIdProperty)) {
                val taskMessage = CompressionUtils.decompressTaskMessage(jacksonJmsMessageConverter.fromMessage(m).asInstanceOf[Array[Byte]])
                info(s"Found message in archive queue for taskId [$taskId]")
                return Some(taskMessage.archiveDetails.taskDetails)
              }
            case _ =>
          }
        }
        debug(s"No messages with taskId [$taskId] found in archive queue - try searching the archive")
        None
      }
    )
  }
}
