package com.xebialabs.deployit.engine.tasker.log.elastic

import com.sksamuel.elastic4s.ElasticDsl._
import com.sksamuel.elastic4s.{ElasticClient, Index}
import com.sksamuel.elastic4s.ElasticDsl.{deleteByQuery, matchQuery, must, search}
import com.sksamuel.elastic4s.requests.searches.SearchIterator

class ElasticLogRetrieverHelper(client: ElasticClient, logIndex: String) {

  def getHits(taskId: String): List[Map[String, AnyRef]] = {
    SearchIterator.hits(client, search(logIndex + "*") query
      must(matchQuery(TASK_ID, taskId))
      keepAlive(timeout)
      sourceInclude(STEP_PATH, MESSAGE, FAILURE_COUNT)
      sortByFieldAsc(TIMESTAMP)
      size(10)
    ).map(_.sourceAsMap).toList
  }

  def getHits(taskId: String, blockId: String): List[Map[String, AnyRef]] = {
    SearchIterator.hits(client, search(logIndex + "*") query
      must(
        matchQuery(TASK_ID, taskId),
        matchQuery(STEP_PATH, blockId)
      )
      keepAlive(timeout)
      sourceInclude(MESSAGE, FAILURE_COUNT)
      sortByFieldAsc(TIMESTAMP)
    ).map(_.sourceAsMap).toList
  }

  def removeLogs(taskId: String): Unit = {
    client.execute {
      deleteByQuery(Index(logIndex + "*"), matchQuery(TASK_ID, taskId))
    }.await
  }

}
