package com.xebialabs.deployit.security.archive

import com.xebialabs.deployit.security.Role

import scala.collection.mutable

trait ArchiveSecurity {

  def getRole(id: String): Role

  def getPermissions(roleId: String): PermissionDto

  def doCreate(id: String, name: String, childRoleIds: Seq[String], principals: Seq[String], onConfigurationItem: Number): Unit

  def doUpdate(original: Role, updated: Role, originalPrincipals: Set[String], updatedPrincipals: Set[String],
  originalRoleIds: Set[String], updateRoleIds: Set[String]): Unit

  def doDelete(id: String): Unit

  def doListDelete(ids: List[String]): Unit

  def updatePermissions(id: Number,
                        createdPermissions: mutable.Map[String, List[String]],
                        deletedPermissions: mutable.Map[String, List[String]]): Unit

  def removeCiPermissions(CiPk: Number): Unit

}

final case class PermissionDto(roleId: String, onConfigurationItem: Number, permissions: List[String])

final case class NoSuchElementInSecurityArchiveException(private val message: String = "Element could not be retrieved from the database",
                                 private val cause: Throwable = None.orNull)
  extends java.lang.RuntimeException(message, cause)
