package com.xebialabs.deployit.core.api;

import com.xebialabs.deployit.core.api.dto.AddUserCredentials;
import com.xebialabs.deployit.core.api.dto.IdDto;
import com.xebialabs.deployit.core.api.dto.UpdateUserCredentials;
import com.xebialabs.deployit.core.api.dto.UserCredentialsView;
import org.springframework.web.bind.annotation.RequestBody;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;
import java.util.Set;

@Path("user/credentials")
@Produces({ MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON })
public interface XldUserCredentialsService {
    @GET
    @Path("{username}")
    Set<UserCredentialsView> listUserCredentials(@PathParam("username") String username);

    @GET
    @Path("{username}/default")
    UserCredentialsView getDefaultUserCredentials(@PathParam("username") String username);

    @POST
    @Path("{username}")
    IdDto<Long> saveUserCredentials(@PathParam("username") String username, @RequestBody AddUserCredentials credentials);

    @PUT
    @Path("{username}")
    IdDto<Long> updateUserCredentials(@PathParam("username") String username, @RequestBody UpdateUserCredentials credentials);

}
