package com.xebialabs.deployit.core.api.dto;

import javax.xml.bind.annotation.XmlRootElement;

/**
 * Summary of active sessions
 */

@XmlRootElement
public class UserSessionsOverview {
    private int totalActiveUsers;
    private int totalControlTasks;
    private int totalDeploymentTasks;

    public UserSessionsOverview() {
        // Don't remove, it's used implicitly
    }

    public UserSessionsOverview(final int totalActiveUsers, final int totalControlTasks, final int totalDeploymentTasks) {
        this.totalActiveUsers = totalActiveUsers;
        this.totalControlTasks = totalControlTasks;
        this.totalDeploymentTasks = totalDeploymentTasks;
    }

    public int getTotalActiveUsers() {
        return totalActiveUsers;
    }

    public void setTotalActiveUsers(int totalActiveUsers) {
        this.totalActiveUsers = totalActiveUsers;
    }

    public int getTotalControlTasks() {
        return totalControlTasks;
    }

    public void setTotalControlTasks(int totalControlTasks) {
        this.totalControlTasks = totalControlTasks;
    }

    public int getTotalDeploymentTasks() {
        return totalDeploymentTasks;
    }

    public void setTotalDeploymentTasks(int totalDeploymentTasks) {
        this.totalDeploymentTasks = totalDeploymentTasks;
    }

    @Override
    public String toString() {
        return "UserSessionsOverview{" +
                "totalActiveUsers=" + totalActiveUsers +
                ", totalControlTasks='"  + totalControlTasks +
                ", totalDeploymentTasks='" + totalDeploymentTasks +
                '}';
    }
}
