package com.xebialabs.deployit.core.api.dto;

import com.xebialabs.xlplatform.documentation.PublicApiRef;

import javax.xml.bind.annotation.XmlRootElement;

/**
 * A reference to a dictionary: its ID and its CI type.
 */
@XmlRootElement
@PublicApiRef
public class DefinedPlaceholderReference {

    private String id;
    private String ciType;
    private String securedCiId;

    public DefinedPlaceholderReference() {
    }

    public DefinedPlaceholderReference(String id, String ciType, String securedCiId) {
        this.id = id;
        this.ciType = ciType;
        this.securedCiId = securedCiId;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCiType() {
        return ciType;
    }

    public void setCiType(String ciType) {
        this.ciType = ciType;
    }

    public String getSecuredCiId() {
        return securedCiId;
    }

    public void setSecuredCiId(final String securedCiId) {
        this.securedCiId = securedCiId;
    }

    @Override
    public String toString() {
        return "DefinedPlaceholderReference{" +
                "id='" + id + '\'' +
                ", ciType='" + ciType + '\'' +
                ", securedCiId='" + securedCiId + '\'' +
                '}';
    }
}
