package com.xebialabs.deployit.core.api.dto;

import javax.xml.bind.annotation.XmlRootElement;

/**
 * General reference holder for resolved placeholders. Pointer to a CI, whether it exists and whether the user has read access to it.
 */
@XmlRootElement
public class ResolvedPlaceholderReference {

    private String id;
    private Boolean canRead;
    private Boolean exists;

    public ResolvedPlaceholderReference() {
    }

    public ResolvedPlaceholderReference(String id, Boolean canRead, Boolean exists) {
        this.id = id;
        this.canRead = canRead;
        this.exists = exists;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Boolean getCanRead() {
        return canRead;
    }

    public void setCanRead(Boolean canRead) {
        this.canRead = canRead;
    }

    public Boolean getExists() {
        return exists;
    }

    public void setExists(Boolean exists) {
        this.exists = exists;
    }

    @Override
    public String toString() {
        return "ResolvedPlaceholderReference{" +
                "id='" + id + '\'' +
                ", canRead=" + canRead +
                ", exists=" + exists +
                '}';
    }
}
