package com.xebialabs.deployit.core.api.dto;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.xebialabs.deployit.core.api.jaxb.MapAdapter;
import com.xebialabs.deployit.engine.api.xml.OmitXmlPreamble;
import com.xebialabs.xltype.serialization.util.DateUtil;
import org.joda.time.DateTime;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.HashMap;
import java.util.Map;

@XmlRootElement(name = "lines")
@OmitXmlPreamble
public class ReportLine {

    private Map<String, Object> values;

    @JsonAnyGetter
    @XmlJavaTypeAdapter(MapAdapter.class)
    public Map<String, Object> getValues() {
        return values;
    }

    public void setValues(final Map<String, Object> values) {
        this.values = values;
    }

    public void addValue(final String key, final Object value) {
        if (values == null) {
            values = new HashMap<>();
        }
        values.put(key, value);
    }

    public static ReportLine fromMap(Map<String, Object> map) {
        ReportLine reportLine = new ReportLine();
        reportLine.setValues(convertValuesToString(map));
        return reportLine;
    }

    private static Map<String, Object> convertValuesToString(Map<String, Object> map) {
        map.replaceAll((key, value) -> {
            if (value instanceof DateTime) {
                return DateUtil.toString((DateTime) value);
            } else if (value != null) {
                return value.toString();
            } else {
                return null;
            }
        });
        return map;
    }

}
