package com.xebialabs.deployit.core.server.service;

import com.xebialabs.deployit.core.events.ChangeSetEvent;

/**
 * Service, created to notify other parties about the changes over events.
 */
public interface EventNotificationService {

    /**
     * Sends a notification to JMS channel which is going to be picked.
     * Used to notify client (GUI) over the changes with a subsequent call via WebSockets.
     *
     * @param event set of changed CIs
     */
    void sendChangeSetEvent(ChangeSetEvent event);
}
