package com.xebialabs.deployit.core.api.dto;

import com.xebialabs.xlplatform.documentation.PublicApiRef;

import javax.xml.bind.annotation.XmlRootElement;

/**
 * Contains information about resolved placeholders: its key, its value (if readable), whether the value is from an encrypted
 * dictionary, which dictionary it is from, and to which containers, deployed application, and environment it is restricted
 */
@XmlRootElement
@PublicApiRef
public class ResolvedPlaceholderView {
    private Boolean isEncrypted;
    private String key;
    private String value;
    private ResolvedPlaceholderReference container;
    private ResolvedPlaceholderReference deployedApp;
    private ResolvedPlaceholderReference dictionary;
    private ResolvedPlaceholderReference environment;
    private String versionId;

    public ResolvedPlaceholderView() {
        // Don't remove, it's used implicitly
    }

    public ResolvedPlaceholderView(
            Boolean isEncrypted,
            String key,
            String value,
            ResolvedPlaceholderReference container,
            ResolvedPlaceholderReference deployedApp,
            ResolvedPlaceholderReference dictionary,
            ResolvedPlaceholderReference environment,
            String versionId
    ) {
        this.isEncrypted = isEncrypted;
        this.key = key;
        this.value = value;
        this.container = container;
        this.deployedApp = deployedApp;
        this.dictionary = dictionary;
        this.environment = environment;
        this.versionId = versionId;
    }

    public Boolean getEncrypted() {
        return isEncrypted;
    }

    public void setEncrypted(Boolean encrypted) {
        isEncrypted = encrypted;
    }

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public ResolvedPlaceholderReference getContainer() {
        return container;
    }

    public void setContainer(ResolvedPlaceholderReference container) {
        this.container = container;
    }

    public ResolvedPlaceholderReference getDeployedApp() {
        return deployedApp;
    }

    public void setDeployedApp(ResolvedPlaceholderReference deployedApp) {
        this.deployedApp = deployedApp;
    }

    public ResolvedPlaceholderReference getDictionary() {
        return dictionary;
    }

    public void setDictionary(ResolvedPlaceholderReference dictionary) {
        this.dictionary = dictionary;
    }

    public ResolvedPlaceholderReference getEnvironment() {
        return environment;
    }

    public void setEnvironment(ResolvedPlaceholderReference environment) {
        this.environment = environment;
    }

    public String getVersionId() {
        return versionId;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    @Override
    public String toString() {
        return "ResolvedPlaceholderView{" +
                "isEncrypted=" + isEncrypted +
                ", key='" + key + '\'' +
                ", value='" + value + '\'' +
                ", container=" + container +
                ", deployedApp=" + deployedApp +
                ", dictionary=" + dictionary +
                ", environment=" + environment +
                ", versionId='" + versionId + '\'' +
                '}';
    }
}
