package com.xebialabs.deployit.core.api.dto;

import com.xebialabs.xlplatform.documentation.PublicApiRef;

import javax.xml.bind.annotation.XmlRootElement;

/**
 * Information about placeholders: its key, on which Configuration Item (ID and Type) it is defined, and whether the user is
 * allowed to read its value
 */
@XmlRootElement
@PublicApiRef
public class DefinedPlaceholderView {
    private String key;
    private String ciId;
    private String ciType;
    private Boolean canRead;

    public DefinedPlaceholderView() {
        // Don't remove, it's used implicitly
    }

    public DefinedPlaceholderView(String key, String ciId, String ciType, Boolean canRead) {
        this.key = key;
        this.ciId = ciId;
        this.ciType = ciType;
        this.canRead = canRead;
    }

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getCiId() {
        return ciId;
    }

    public void setCiId(String ciId) {
        this.ciId = ciId;
    }

    public String getCiType() {
        return ciType;
    }

    public void setCiType(String ciType) {
        this.ciType = ciType;
    }

    public Boolean getCanRead() {
        return canRead;
    }

    public void setCanRead(Boolean canRead) {
        this.canRead = canRead;
    }

    @Override
    public String toString() {
        return "DefinedPlaceholderView{" +
                "key='" + key + '\'' +
                ", ciId='" + ciId + '\'' +
                ", ciType='" + ciType + '\'' +
                ", canRead=" + canRead +
                '}';
    }
}
