package com.xebialabs.deployit.core.api.dto;

import com.xebialabs.deployit.engine.api.dto.AbstractDto;

import javax.xml.bind.annotation.XmlRootElement;

/**
 * Has information about currently active user session and it's associated tasks
 */
@XmlRootElement
public class ActiveUserSession extends AbstractDto {
    private String username;
    private boolean internal;
    private int controlTasks;
    private int deploymentTasks;

    public ActiveUserSession() {
        // Don't remove, it's used implicitly
    }

    public ActiveUserSession(final String username, final boolean internal,final int controlTasks, final int deploymentTasks) {
        this.username = username;
        this.internal = internal;
        this.controlTasks = controlTasks;
        this.deploymentTasks = deploymentTasks;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean isInternal() {
        return internal;
    }

    public void setInternal(boolean internal) {
        this.internal = internal;
    }

    public int getControlTasks() {
        return controlTasks;
    }

    public void setControlTasks(int controlTasks) {
        this.controlTasks = controlTasks;
    }

    public int getDeploymentTasks() {
        return deploymentTasks;
    }

    public void setDeploymentTasks(int deploymentTasks) {
        this.deploymentTasks = deploymentTasks;
    }


    @Override
    public String toString() {
        return "ActiveUserSession{" +
                "username=" + username +
                ", internal='"  + internal +
                ", controlTasks='"  + controlTasks +
                ", deploymentTasks='" + deploymentTasks +
                '}';
    }
}
