package com.xebialabs.deployit.core.rest.api.reports.widgets;

import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.api.dto.ReportLine;
import com.xebialabs.deployit.task.archive.DeploymentResult;
import com.xebialabs.deployit.task.archive.TaskArchive;
import com.xebialabs.deployit.task.archive.TopNByStateReportLine;
import org.joda.time.DateTime;

import java.util.Collection;

import static com.xebialabs.deployit.core.util.CiUtils.getIdWithoutRoot;

public abstract class Top10DeploymentsByState extends DashboardWidgetBase {

    private static final String APPLICATION_NAME = "application";
    private static final String ENVIRONMENT = "environment";
    private static final String NUMBER_OF_DEPLOYMENTS_IN_A_STATE = "numOfDeployments";
    /**
     * Total of successful and retried deployments.
     */
    private static final String TOTAL_DEPLOYMENTS = "totalDeployments";
    private static final String PERCENTAGE = "percentage";

    private final DeploymentResult stateType;

    public Top10DeploymentsByState(TaskArchive taskArchive, DeploymentResult stateType) {
        super(taskArchive);
        this.stateType = stateType;
    }

    @Override
    public Report getReport(final DateTime begin, final DateTime end) {
        Collection<TopNByStateReportLine> searchResult =
                taskArchive.topNDeploymentsByState(begin, end, stateType, TOP_N);
        return transformResult(searchResult);
    }

    private Report transformResult(Collection<TopNByStateReportLine> searchResult) {
        Report report = new Report();
        searchResult.forEach(sr -> {
            ReportLine reportLine = report.addLine();
            reportLine.addValue(APPLICATION_NAME, sr.application());
            reportLine.addValue(ENVIRONMENT, getIdWithoutRoot(sr.environment()));
            reportLine.addValue(NUMBER_OF_DEPLOYMENTS_IN_A_STATE, String.valueOf(sr.numOfDeployTasksInAState()));
            reportLine.addValue(TOTAL_DEPLOYMENTS, String.valueOf(sr.totalDeployTasks()));
            reportLine.addValue(PERCENTAGE, getFormattedPercentage(sr.numOfDeployTasksInAState(), sr.totalDeployTasks()));
        });
        return report;
    }
}