package com.xebialabs.deployit.core.writer

import com.thoughtworks.xstream.XStream
import com.xebialabs.deployit.core.rest.xml.{ArchivedTaskWriter, StepStateWriter}
import com.xebialabs.deployit.task.archive.ArchivedTask
import com.xebialabs.xltype.serialization.xstream.XStreamReaderWriter
import org.springframework.stereotype.Component

@Component
class TaskArchiveWriter extends XStream(XStreamReaderWriter.HIERARCHICAL_STREAM_DRIVER) {
  this.registerConverter(new ArchivedTaskWriter())
  this.registerConverter(new StepStateWriter())
  this.aliasType("task", classOf[ArchivedTask])
}
