/**
 * Copyright 2014-2018 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.core.rest.converters;

import com.xebialabs.deployit.core.api.dto.BannerInfo;
import com.xebialabs.xltype.serialization.json.JsonWriter;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

import static com.xebialabs.deployit.checks.Checks.checkArgument;

public class BannerInfoJsonConverter {

    private static final String CONTENT = "content";
    private static final String KIND = "kind";

    public BannerInfoJsonConverter() {
    }

    public String toJson(BannerInfo bannerInfo) {
        JsonWriter writer = new JsonWriter();
        toJson(bannerInfo, writer);
        return writer.toString();
    }

    public void toJson(final BannerInfo bannerInfo, final JsonWriter writer) {
        writer.object();

        writer.key("kind").value(bannerInfo.getKind().name());
        writer.key(CONTENT).value(bannerInfo.getContent());

        writer.endObject();
    }

    public BannerInfo toBannerInfo(String jsonString) {
        try {
            JSONObject json = new JSONObject(jsonString);

            checkArgument(json.has(KIND), "Missing 'kind' property in JSON:\n%s", jsonString);
            checkArgument(json.has(CONTENT), "Missing 'content' property in JSON:\n%s", jsonString);
            BannerInfo.BannerKind kind = BannerInfo.BannerKind.fromValue(json.getString(KIND));
            return new BannerInfo(kind, json.getString(CONTENT));

        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Can't parse JSON:\n" + jsonString, e);
        }
    }
}
