package com.xebialabs.deployit.core.rest.json

import java.io.{IOException, OutputStream, OutputStreamWriter}
import java.lang.annotation.Annotation
import java.lang.reflect.Type
import java.util

import com.xebialabs.deployit.core.api.dto.{UserSessionsOverview}
import com.xebialabs.xltype.serialization.json.JsonWriter
import javax.ws.rs.core.{MediaType, MultivaluedMap}
import javax.ws.rs.ext.{MessageBodyWriter, Provider}
import javax.ws.rs.{Produces, WebApplicationException}
import org.springframework.stereotype.Component

@Component
@Provider
@Produces(Array(MediaType.APPLICATION_JSON))
class UserSessionsOverviewJsonWriter extends MessageBodyWriter[util.Collection[UserSessionsOverview]] {

  private val helper = new JsonWriterHelper

  override def isWriteable(`type`: Class[_], genericType: Type, annotations: Array[Annotation],
                           mediaType: MediaType): Boolean = classOf[UserSessionsOverview].isAssignableFrom(helper.getType(`type`, genericType))

  override def getSize(viewList: util.Collection[UserSessionsOverview], `type`: Class[_], genericType: Type, annotations: Array[Annotation],
                       mediaType: MediaType): Long = -1

  @throws[IOException]
  @throws[WebApplicationException]
  override def writeTo(viewList: util.Collection[UserSessionsOverview], `type`: Class[_], genericType: Type, annotations: Array[Annotation],
                       mediaType: MediaType, httpHeaders: MultivaluedMap[String, AnyRef],
                       entityStream: OutputStream): Unit = {
    val reportStreamWriter: OutputStreamWriter = new OutputStreamWriter(entityStream)
    writeJson(viewList, new JsonWriter(reportStreamWriter))
    reportStreamWriter.flush()
  }

  private def writeJson(viewList: util.Collection[UserSessionsOverview], writer: JsonWriter): Unit = {
    writer.array
    viewList.forEach(view => {
      writer.`object`()
      writer.key("username").value(view.getTotalActiveUsers)
      writer.key("internal").value(view.getTotalControlTasks)
      writer.key("controlTasks").value(view.getTotalDeploymentTasks)
      writer.endObject()
    })
    writer.endArray
  }
}
