/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.json;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;
import org.springframework.stereotype.Component;

@Component
@Provider
@Produces(value={"application/json"})
public class StreamJsonWriter
implements MessageBodyWriter<Stream<Object>> {
    @Context
    private Providers providers;

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Stream.class.isAssignableFrom(type) && genericType instanceof ParameterizedType;
    }

    public long getSize(Stream<Object> objectStream, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Stream<Object> stream, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        Type argumentType = ((ParameterizedType)genericType).getActualTypeArguments()[0];
        MessageBodyWriter writer = this.providers.getMessageBodyWriter((Class)argumentType, argumentType, annotations, mediaType);
        try (Stream<Object> s = stream;){
            entityStream.write(91);
            s.forEachOrdered(new WritingConsumer(writer, argumentType, annotations, mediaType, httpHeaders, entityStream));
            entityStream.write(93);
        }
    }

    private static class WritingConsumer
    implements Consumer<Object> {
        private final MessageBodyWriter writer;
        private final Type argumentType;
        private final Annotation[] annotations;
        private final MediaType mediaType;
        private final MultivaluedMap<String, Object> httpHeaders;
        private final OutputStream entityStream;
        private boolean first = true;

        private WritingConsumer(MessageBodyWriter writer, Type argumentType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) {
            this.writer = writer;
            this.argumentType = argumentType;
            this.annotations = annotations;
            this.mediaType = mediaType;
            this.httpHeaders = httpHeaders;
            this.entityStream = entityStream;
        }

        @Override
        public void accept(Object o) {
            try {
                if (this.first) {
                    this.first = false;
                } else {
                    this.entityStream.write(44);
                }
                this.writer.writeTo(o, o.getClass(), this.argumentType, this.annotations, this.mediaType, this.httpHeaders, this.entityStream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

