/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.websockets;

import com.xebialabs.deployit.core.events.CiRef;
import com.xebialabs.deployit.core.events.JmsCiChangeSetEvent;
import com.xebialabs.deployit.core.websockets.WebSocketEndpoints;
import com.xebialabs.deployit.engine.spi.event.MaintenanceStartEvent;
import com.xebialabs.deployit.engine.spi.event.MaintenanceStopEvent;
import com.xebialabs.deployit.event.EventBusHolder;
import java.io.Serializable;
import java.util.Collection;
import nl.javadude.t2bus.Subscribe;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Autowired
@Controller
@ScalaSignature(bytes="\u0006\u0005\u0005Ec\u0001\u0002\u0006\f\u0001aA\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001\t\u0005\u0006o\u0001!\t\u0001\u000f\u0005\u0006{\u0001!\tA\u0010\u0005\u0006+\u0002!\tA\u0016\u0005\u0006E\u0002!\ta\u0019\u0005\u0006S\u0002!IA\u001b\u0005\u0006a\u0002!I!\u001d\u0005\u0006u\u0002!Ia\u001f\u0005\b\u0003;\u0001A\u0011BA\u0010\u0005]9VMY*pG.,G/T3tg\u0006<Wm]*f]\u0012,'O\u0003\u0002\r\u001b\u0005Qq/\u001a2t_\u000e\\W\r^:\u000b\u00059y\u0011\u0001\u0002:fgRT!\u0001E\t\u0002\t\r|'/\u001a\u0006\u0003%M\t\u0001\u0002Z3qY>L\u0018\u000e\u001e\u0006\u0003)U\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003Y\t1aY8n\u0007\u0001\u0019\"\u0001A\r\u0011\u0005iiR\"A\u000e\u000b\u0003q\tQa]2bY\u0006L!AH\u000e\u0003\r\u0005s\u0017PU3g\u0003=iWm]:bO\u0016$V-\u001c9mCR,\u0007CA\u0011+\u001b\u0005\u0011#BA\u0012%\u0003\u0011\u0019\u0018.\u001c9\u000b\u0005\u00152\u0013!C7fgN\fw-\u001b8h\u0015\t9\u0003&A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005I\u0013aA8sO&\u00111F\t\u0002\u0016'&l\u0007/T3tg\u0006<\u0017N\\4UK6\u0004H.\u0019;fQ\t\tQ\u0006\u0005\u0002/k5\tqF\u0003\u00021c\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005I\u001a\u0014a\u00024bGR|'/\u001f\u0006\u0003i\u0019\nQAY3b]NL!AN\u0018\u0003\u0013\u0005+Ho\\<je\u0016$\u0017A\u0002\u001fj]&$h\b\u0006\u0002:wA\u0011!\bA\u0007\u0002\u0017!)qD\u0001a\u0001A!\u00121(L\u0001\u001ag\u0016tGmV:DS\u000eC\u0017M\\4f'\u0016$X*Z:tC\u001e,7\u000f\u0006\u0002@\u0005B\u0011!\u0004Q\u0005\u0003\u0003n\u0011A!\u00168ji\")1i\u0001a\u0001\t\u0006)QM^3oiB\u0011Q\tS\u0007\u0002\r*\u0011qiD\u0001\u0007KZ,g\u000e^:\n\u0005%3%a\u0005&ng\u000eK7\t[1oO\u0016\u001cV\r^#wK:$\bFA\u0002L!\ta5+D\u0001N\u0015\tqu*A\u0003ue\t,8O\u0003\u0002Q#\u0006A!.\u0019<bIV$WMC\u0001S\u0003\tqG.\u0003\u0002U\u001b\nI1+\u001e2tGJL'-Z\u0001\u0017g\u0016tG-T1j]R,g.\u00198dKN#\u0018M\u001d;fIR\u0011qh\u0016\u0005\u0006\u0007\u0012\u0001\r\u0001\u0017\t\u00033~k\u0011A\u0017\u0006\u0003\u0007nS!\u0001X/\u0002\u0007M\u0004\u0018N\u0003\u0002_#\u00051QM\\4j]\u0016L!\u0001\u0019.\u0003+5\u000b\u0017N\u001c;f]\u0006t7-Z*uCJ$XI^3oi\"\u0012AaS\u0001\u0017g\u0016tG-T1j]R,g.\u00198dKN#x\u000e\u001d9fIR\u0011q\b\u001a\u0005\u0006\u0007\u0016\u0001\r!\u001a\t\u00033\u001aL!a\u001a.\u0003)5\u000b\u0017N\u001c;f]\u0006t7-Z*u_B,e/\u001a8uQ\t)1*\u0001\u0011o_RLg-_!c_V$X*Y5oi\u0016t\u0017M\\2f\u001b>$Wm\u00115b]\u001e,GCA l\u0011\u0015ag\u00011\u0001n\u0003\u001d)g.\u00192mK\u0012\u0004\"A\u00078\n\u0005=\\\"a\u0002\"p_2,\u0017M\\\u0001\fO\u0016$Xk]3s\u001d\u0006lW-F\u0001s!\t\u0019\b0D\u0001u\u0015\t)h/\u0001\u0003mC:<'\"A<\u0002\t)\fg/Y\u0005\u0003sR\u0014aa\u0015;sS:<\u0017a\u00058pi&4\u0017pQ5t\u0013\u001atu\u000e^#naRLH\u0003B }\u0003\u000fAQ! \u0005A\u0002y\f\u0001\"\u001a8ea>Lg\u000e\u001e\t\u0004\u007f\u0006\rQBAA\u0001\u0015\taq\"\u0003\u0003\u0002\u0006\u0005\u0005!AE,fEN{7m[3u\u000b:$\u0007o\\5oiNDq!!\u0003\t\u0001\u0004\tY!A\u0003dS&#7\u000f\u0005\u0004\u0002\u000e\u0005M\u0011qC\u0007\u0003\u0003\u001fQ1!!\u0005w\u0003\u0011)H/\u001b7\n\t\u0005U\u0011q\u0002\u0002\u000b\u0007>dG.Z2uS>t\u0007cA#\u0002\u001a%\u0019\u00111\u0004$\u0003\u000b\rK'+\u001a4\u000239|G/\u001b4z/&$\b.\u0013;f[NLeMT8u\u000b6\u0004H/_\u000b\u0005\u0003C\ty\u0003F\u0003@\u0003G\t)\u0003C\u0003~\u0013\u0001\u0007a\u0010C\u0004\u0002(%\u0001\r!!\u000b\u0002\u000b%$X-\\:\u0011\r\u00055\u00111CA\u0016!\u0011\ti#a\f\r\u0001\u00119\u0011\u0011G\u0005C\u0002\u0005M\"!\u0001+\u0012\t\u0005U\u00121\b\t\u00045\u0005]\u0012bAA\u001d7\t9aj\u001c;iS:<\u0007c\u0001\u000e\u0002>%\u0019\u0011qH\u000e\u0003\u0007\u0005s\u0017\u0010K\u0002\u0001\u0003\u0007\u0002B!!\u0012\u0002L5\u0011\u0011q\t\u0006\u0004\u0003\u00132\u0013AC:uKJ,w\u000e^=qK&!\u0011QJA$\u0005)\u0019uN\u001c;s_2dWM\u001d\u0015\u0003\u00015\u0002")
public class WebSocketMessagesSender {
    @Autowired
    private final SimpMessagingTemplate messageTemplate;

    @Subscribe
    public void sendWsCiChangeSetMessages(JmsCiChangeSetEvent event) {
        this.notifyCisIfNotEmpty(WebSocketEndpoints.TOPIC_CI_CREATE, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)event.createCis()).asJava());
        this.notifyCisIfNotEmpty(WebSocketEndpoints.TOPIC_CI_UPDATE, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)event.updateCis()).asJava());
        this.notifyWithItemsIfNotEmpty(WebSocketEndpoints.TOPIC_CI_DELETE, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)event.deleteCis()).asJava());
        this.notifyWithItemsIfNotEmpty(WebSocketEndpoints.TOPIC_CI_RENAME, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)event.renameCis()).asJava());
        this.notifyWithItemsIfNotEmpty(WebSocketEndpoints.TOPIC_CI_MOVE, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)event.moveCis()).asJava());
        this.notifyWithItemsIfNotEmpty(WebSocketEndpoints.TOPIC_CI_COPY, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)event.copyCis()).asJava());
    }

    @Subscribe
    public void sendMaintenanceStarted(MaintenanceStartEvent event) {
        this.notifyAboutMaintenanceModeChange(true);
    }

    @Subscribe
    public void sendMaintenanceStopped(MaintenanceStopEvent event) {
        this.notifyAboutMaintenanceModeChange(false);
    }

    private void notifyAboutMaintenanceModeChange(boolean enabled) {
        this.messageTemplate.convertAndSend((Object)WebSocketEndpoints.TOPIC_MAINTENANCE.getName(), (Object)BoxesRunTime.boxToBoolean((boolean)enabled));
    }

    private String getUserName() {
        return (String)Option$.MODULE$.apply((Object)SecurityContextHolder.getContext().getAuthentication()).map((Function1 & Serializable)x$1 -> x$1.getName()).getOrElse((Function0 & Serializable)() -> "admin");
    }

    private void notifyCisIfNotEmpty(WebSocketEndpoints endpoint, Collection<CiRef> ciIds) {
        this.notifyWithItemsIfNotEmpty(endpoint, ciIds);
    }

    private <T> void notifyWithItemsIfNotEmpty(WebSocketEndpoints endpoint, Collection<T> items) {
        block0: {
            if (items.isEmpty()) break block0;
            this.messageTemplate.convertAndSendToUser(this.getUserName(), endpoint.getName(), items);
        }
    }

    public WebSocketMessagesSender(@Autowired SimpMessagingTemplate messageTemplate) {
        this.messageTemplate = messageTemplate;
        EventBusHolder.register((Object)this);
    }
}

