package com.xebialabs.deployit.core.rest.api

import java.util
import com.xebialabs.deployit.ServerConfiguration
import com.xebialabs.deployit.core.api.ConfigurationService
import com.xebialabs.deployit.core.api.dto.{LicenseDto, LicensedCiUsageDto}
import com.xebialabs.deployit.core.config.{ClientProperties, ServerSideProperties}
import com.xebialabs.deployit.core.config.ClientProperties._
import com.xebialabs.deployit.core.config.ServerSideProperties._
import com.xebialabs.license.LicenseProperty
import com.xebialabs.license.service.LicenseService
import org.springframework.beans.factory.annotation.{Autowired, Value}
import org.springframework.stereotype.Service

@Service
class ConfigurationServiceImpl extends ConfigurationService {

  @Autowired
  var config: ServerConfiguration = _

  @Autowired
  var licenseService: LicenseService = _

  @Value("${xl.deploy.stitch.enabled:true}")
  var stitchEnabled: String = _

  @Autowired
  var clientConfiguration: ClientProperties = _

  @Autowired
  var serverSideConfiguration: ServerSideProperties = _

  override def getProperties: util.Map[String, String] = {
    val gui = clientConfiguration.gui

    val properties = new util.HashMap[String, String]

    def addProperty(key: String, value: Any): Unit = {
      properties.put(key, value + "")
    }

    addProperty(KEY_ACTIVE_USER_SESSIONS, serverSideConfiguration.getSession.getActiveUserSessionsEnabled)
    addProperty(KEY_CLIENT_SESSION_TIMEOUT_MINUTES, clientConfiguration.getSession.getTimeoutMinute)

    addProperty(KEY_CLIENT_SESSION_REMEMBER_ENABLED, clientConfiguration.sessionRememberEnabled)
    addProperty(KEY_CLIENT_AUTOMATICALLY_MAP_ALL_DEPLOYABLES, clientConfiguration.automaticallyMapAllDeployables)
    addProperty(KEY_CLIENT_AUTOMATICALLY_MAP_ALL_DEPLOYABLES_ON_INITIAL, clientConfiguration.automaticallyMapAllDeployablesOnInitial)
    addProperty(KEY_CLIENT_AUTOMATICALLY_MAP_ALL_DEPLOYABLES_ON_UPDATE, clientConfiguration.automaticallyMapAllDeployablesOnUpdate)

    val toastr = gui.toastr
    addProperty("gui.toastr.error.timeout-ms", toastr.error.timeoutMs)
    addProperty("gui.toastr.info.timeout-ms", toastr.info.timeoutMs)
    addProperty("gui.toastr.success.timeout-ms", toastr.success.timeoutMs)
    addProperty("gui.toastr.warning.timeout-ms", toastr.warning.timeoutMs)
    addProperty("gui.landing-page", gui.landingPage)
    addProperty("gui.task.status.poll-interval-ms", gui.task.status.poll.timeoutMs)
    addProperty("deploy.stitch.enabled", stitchEnabled)
    addProperty("server.label", serverSideConfiguration.getLabel)

    properties
  }

  override def getLicenseInfo: LicenseDto = {
    val license = licenseService.getLicense
    val licenseDto = new LicenseDto(license.getStringValue(LicenseProperty.PRODUCT), license.getStringValue(LicenseProperty.LICENSED_TO), license.getStringValue(LicenseProperty.CONTACT))
    val expiresAfter = license.getStringValue(LicenseProperty.EXPIRES_AFTER)
    licenseDto.setExpiresAfter(expiresAfter)
    val ciUses = licenseService.getCounter.licensedCisInUse
    for (ciUse <- ciUses) {
      licenseDto.getLicensedCiUsages.add(new LicensedCiUsageDto(ciUse.`type`.toString, ciUse.allowedAmount, ciUse.actualAmount))
    }
    licenseDto.setSupportPolicy(license.getStringValue(LicenseProperty.SUPPORT_POLICY))
    licenseDto.setEdition(license.getStringValue(LicenseProperty.EDITION))
    val plugins = license.getListValue(LicenseProperty.LICENSED_PLUGINS)
    licenseDto.setMaxUsers(license.getStringValue(LicenseProperty.MAX_NUMBER_OF_USERS))
    licenseDto.getLicensedPlugins.addAll(plugins)
    licenseDto
  }
}
