package com.xebialabs.deployit.core.util

import com.xebialabs.deployit.checks.Checks
import com.xebialabs.deployit.core.api.dto.settings.GeneralSettings

object GeneralSettingsUtils {

  // 1 MB
  private val MAX_LOGO_FILE_SIZE_BYTES = 1048576

  def validate(generalSetting: GeneralSettings): Unit = {
    validateLogoFile(generalSetting.logoFile)
  }

  private def validateLogoFile(logoFile: String): Unit = {
    if (logoFile.nonEmpty) {
      validateLogoFileSize(logoFile)
      validateLogoFileType(logoFile)
    }
  }

  private def validateLogoFileSize(logoFile: String): Unit = {
    val characterCount = logoFile.length;
    val paddingCount = logoFile.substring(characterCount - 2, characterCount).count(c => c == '=')
    val sizeInBytes = (3 * (characterCount / 4)) - paddingCount;
    Checks.checkTrue(sizeInBytes <= MAX_LOGO_FILE_SIZE_BYTES, "Logo file is too large. Maximum size is 1 MB")
  }

  private def validateLogoFileType(logoFile: String): Unit = {
    Checks.checkTrue(logoFile.substring("data:".length).startsWith("image/"), "Logo file must be of an image file type.")
  }
}
