/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.websockets;

import com.xebialabs.deployit.core.config.ClientConfiguration;
import com.xebialabs.deployit.core.config.WebSocketsConfiguration;
import com.xebialabs.deployit.core.rest.converters.CiIdsMessageConverter;
import com.xebialabs.deployit.core.rest.json.CiRefsJsonWriter;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.messaging.handler.invocation.HandlerMethodReturnValueHandler;
import org.springframework.messaging.simp.config.ChannelRegistration;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.web.socket.config.annotation.EnableWebSocketMessageBroker;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.config.annotation.WebSocketMessageBrokerConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketTransportRegistration;
import org.springframework.web.socket.server.HandshakeHandler;
import org.springframework.web.socket.server.RequestUpgradeStrategy;
import org.springframework.web.socket.server.jetty.JettyRequestUpgradeStrategy;
import org.springframework.web.socket.server.support.DefaultHandshakeHandler;
import scala.reflect.ScalaSignature;

@Configuration
@EnableWebSocketMessageBroker
@ScalaSignature(bytes="\u0006\u0005\u0005ee\u0001\u0002\b\u0010\u0001qA\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u000f\"AQ\u000b\u0001B\u0001B\u0003%a\u000b\u0003\u0005b\u0001\t\u0005\t\u0015!\u0003c\u0011!A\u0007A!A!\u0002\u0013I\u0007\"B7\u0001\t\u0003q\u0007bB?\u0001\u0005\u0004%IA \u0005\b\u0003\u0017\u0001\u0001\u0015!\u0003\u0000\u0011\u001d\ti\u0001\u0001C!\u0003\u001fAq!!\u000b\u0001\t\u0003\tY\u0003C\u0004\u0002L\u0001!\t%!\u0014\t\u000f\u0005]\u0003\u0001\"\u0011\u0002Z!9\u00111\r\u0001\u0005B\u0005\u0015$\u0001H,fEN{7m[3u\u001b\u0016\u001c8/Y4f\u0005J|7.\u001a:D_:4\u0017n\u001a\u0006\u0003!E\t!b^3cg>\u001c7.\u001a;t\u0015\t\u00112#\u0001\u0003sKN$(B\u0001\u000b\u0016\u0003\u0011\u0019wN]3\u000b\u0005Y9\u0012\u0001\u00033fa2|\u00170\u001b;\u000b\u0005aI\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005Q\u0012aA2p[\u000e\u00011c\u0001\u0001\u001eKA\u0011adI\u0007\u0002?)\u0011\u0001%I\u0001\u0005Y\u0006twMC\u0001#\u0003\u0011Q\u0017M^1\n\u0005\u0011z\"AB(cU\u0016\u001cG\u000f\u0005\u0002'g5\tqE\u0003\u0002)S\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005)Z\u0013AB2p]\u001aLwM\u0003\u0002-[\u000511o\\2lKRT!AL\u0018\u0002\u0007],'M\u0003\u00021c\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u00013\u0003\ry'oZ\u0005\u0003i\u001d\u0012\u0001eV3c'>\u001c7.\u001a;NKN\u001c\u0018mZ3Ce>\\WM]\"p]\u001aLw-\u001e:fe\u0006\u00012-\u001b*fMNT5o\u001c8Xe&$XM\u001d\t\u0003oij\u0011\u0001\u000f\u0006\u0003sE\tAA[:p]&\u00111\b\u000f\u0002\u0011\u0007&\u0014VMZ:Kg>twK]5uKJD#!A\u001f\u0011\u0005y\"U\"A \u000b\u0005!\u0002%BA!C\u0003\u001d1\u0017m\u0019;pefT!aQ\u0018\u0002\u000b\t,\u0017M\\:\n\u0005\u0015{$!C!vi><\u0018N]3e\u00035!\u0018m]6TG\",G-\u001e7feB\u0011\u0001jS\u0007\u0002\u0013*\u0011!jL\u0001\u000bg\u000eDW\rZ;mS:<\u0017B\u0001'J\u00055!\u0016m]6TG\",G-\u001e7fe\"\"!AT)S!\tqt*\u0003\u0002Q\u007f\tI\u0011+^1mS\u001aLWM]\u0001\u0006m\u0006dW/Z\u0011\u0002'\u0006\u0019r/\u001a2t_\u000e\\W\r^:TG\",G-\u001e7fe\"\u0012!!P\u0001\u0010kN,'/\u00138uKJ\u001cW\r\u001d;peB\u0011q\u000bX\u0007\u00021*\u0011\u0011LW\u0001\bgV\u0004\bo\u001c:u\u0015\tYv&A\u0005nKN\u001c\u0018mZ5oO&\u0011Q\f\u0017\u0002\u0013\u0007\"\fgN\\3m\u0013:$XM]2faR|'\u000f\u000b\u0003\u0004\u001dF{\u0016%A+)\u0005\ri\u0014aF<fEN{7m[3ug\u000e{gNZ5hkJ\fG/[8o!\t\u0019W-D\u0001e\u0015\tQ3#\u0003\u0002gI\n9r+\u001a2T_\u000e\\W\r^:D_:4\u0017nZ;sCRLwN\u001c\u0015\u0003\tu\n1c\u00197jK:$8i\u001c8gS\u001e,(/\u0019;j_:\u0004\"a\u00196\n\u0005-$'aE\"mS\u0016tGoQ8oM&<WO]1uS>t\u0007FA\u0003>\u0003\u0019a\u0014N\\5u}Q1q.]:wsn\u0004\"\u0001\u001d\u0001\u000e\u0003=AQ!\u000e\u0004A\u0002YB#!]\u001f\t\u000b\u00193\u0001\u0019A$)\tMt\u0015K\u0015\u0015\u0003gvBQ!\u0016\u0004A\u0002YCCA\u001e(R?\"\u0012a/\u0010\u0005\u0006C\u001a\u0001\rA\u0019\u0015\u0003svBQ\u0001\u001b\u0004A\u0002%D#a_\u001f\u0002\u001f%t\u0007/\u001e;Ck\u001a4WM]*ju\u0016,\u0012a \t\u0005\u0003\u0003\t9!\u0004\u0002\u0002\u0004)\u0011\u0011QA\u0001\u0006g\u000e\fG.Y\u0005\u0005\u0003\u0013\t\u0019AA\u0002J]R\f\u0001#\u001b8qkR\u0014UO\u001a4feNK'0\u001a\u0011\u0002-\r|gNZ5hkJ,W*Z:tC\u001e,'I]8lKJ$B!!\u0005\u0002\u0018A!\u0011\u0011AA\n\u0013\u0011\t)\"a\u0001\u0003\tUs\u0017\u000e\u001e\u0005\b\u00033I\u0001\u0019AA\u000e\u0003!\u0011XmZ5tiJL\b\u0003BA\u000f\u0003Ki!!a\b\u000b\u0007)\n\tCC\u0002\u0002$i\u000bAa]5na&!\u0011qEA\u0010\u0005UiUm]:bO\u0016\u0014%o\\6feJ+w-[:uef\f\u0001\u0003[1oIND\u0017m[3IC:$G.\u001a:\u0015\u0005\u00055\u0002\u0003BA\u0018\u0003oi!!!\r\u000b\u0007e\u000b\u0019DC\u0002\u00026-\naa]3sm\u0016\u0014\u0018\u0002BA\u001d\u0003c\u0011q\u0003R3gCVdG\u000fS1oIND\u0017m[3IC:$G.\u001a:)\u0007)\ti\u0004\u0005\u0003\u0002@\u0005\u001dSBAA!\u0015\rA\u00131\t\u0006\u0004\u0003\u000bz\u0013aB2p]R,\u0007\u0010^\u0005\u0005\u0003\u0013\n\tE\u0001\u0003CK\u0006t\u0017A\u0006:fO&\u001cH/\u001a:Ti>l\u0007/\u00128ea>Lg\u000e^:\u0015\t\u0005E\u0011q\n\u0005\b\u00033Y\u0001\u0019AA)!\r1\u00131K\u0005\u0004\u0003+:#!F*u_6\u0004XI\u001c3q_&tGOU3hSN$(/_\u0001\u001eG>tg-[4ve\u0016\u001cE.[3oi&s'm\\;oI\u000eC\u0017M\u001c8fYR!\u0011\u0011CA.\u0011\u001d\tI\u0002\u0004a\u0001\u0003;\u0002B!!\b\u0002`%!\u0011\u0011MA\u0010\u0005M\u0019\u0005.\u00198oK2\u0014VmZ5tiJ\fG/[8o\u0003i\u0019wN\u001c4jOV\u0014X-T3tg\u0006<WmQ8om\u0016\u0014H/\u001a:t)\u0011\t9'!\u001c\u0011\t\u0005\u0005\u0011\u0011N\u0005\u0005\u0003W\n\u0019AA\u0004C_>dW-\u00198\t\u000f\u0005=T\u00021\u0001\u0002r\u0005\tR.Z:tC\u001e,7i\u001c8wKJ$XM]:\u0011\r\u0005M\u0014\u0011PA?\u001b\t\t)HC\u0002\u0002x\u0005\nA!\u001e;jY&!\u00111PA;\u0005\u0011a\u0015n\u001d;\u0011\t\u0005}\u0014QQ\u0007\u0003\u0003\u0003S1!a![\u0003%\u0019wN\u001c<feR,'/\u0003\u0003\u0002\b\u0006\u0005%\u0001E'fgN\fw-Z\"p]Z,'\u000f^3sQ\r\u0001\u00111\u0012\t\u0004M\u00055\u0015bAAHO\taRI\\1cY\u0016<VMY*pG.,G/T3tg\u0006<WM\u0011:pW\u0016\u0014\bf\u0001\u0001\u0002\u0014B!\u0011qHAK\u0013\u0011\t9*!\u0011\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0001")
public class WebSocketMessageBrokerConfig
implements WebSocketMessageBrokerConfigurer {
    @Autowired
    private final CiRefsJsonWriter ciRefsJsonWriter;
    @Autowired
    @Qualifier(value="websocketsScheduler")
    private final TaskScheduler taskScheduler;
    @Autowired
    @Qualifier(value="userInterceptor")
    private final ChannelInterceptor userInterceptor;
    @Autowired
    private final ClientConfiguration clientConfiguration;
    private final int inputBufferSize;

    public void configureWebSocketTransport(WebSocketTransportRegistration x$1) {
        super.configureWebSocketTransport(x$1);
    }

    public void configureClientOutboundChannel(ChannelRegistration x$1) {
        super.configureClientOutboundChannel(x$1);
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> x$1) {
        super.addArgumentResolvers(x$1);
    }

    public void addReturnValueHandlers(List<HandlerMethodReturnValueHandler> x$1) {
        super.addReturnValueHandlers(x$1);
    }

    private int inputBufferSize() {
        return this.inputBufferSize;
    }

    public void configureMessageBroker(MessageBrokerRegistry registry) {
        registry.setApplicationDestinationPrefixes(new String[]{"/app"});
        registry.enableSimpleBroker(new String[]{"/topic"}).setTaskScheduler(this.taskScheduler);
    }

    @Bean
    public DefaultHandshakeHandler handshakeHandler() {
        WebSocketPolicy policy = new WebSocketPolicy(WebSocketBehavior.SERVER);
        policy.setInputBufferSize(this.inputBufferSize());
        long idleTimeout = TimeUnit.MINUTES.toMillis(this.clientConfiguration.getSession().getTimeoutMinute());
        policy.setIdleTimeout(idleTimeout);
        return new DefaultHandshakeHandler((RequestUpgradeStrategy)new JettyRequestUpgradeStrategy(policy));
    }

    public void registerStompEndpoints(StompEndpointRegistry registry) {
        registry.addEndpoint(new String[]{"/ws"}).setAllowedOriginPatterns(new String[]{"*"}).setHandshakeHandler((HandshakeHandler)this.handshakeHandler()).withSockJS();
    }

    public void configureClientInboundChannel(ChannelRegistration registry) {
        registry.interceptors(new ChannelInterceptor[]{this.userInterceptor});
    }

    public boolean configureMessageConverters(List<MessageConverter> messageConverters) {
        messageConverters.add((MessageConverter)new CiIdsMessageConverter(this.ciRefsJsonWriter));
        return true;
    }

    public WebSocketMessageBrokerConfig(@Autowired CiRefsJsonWriter ciRefsJsonWriter, @Autowired @Qualifier(value="websocketsScheduler") TaskScheduler taskScheduler, @Autowired @Qualifier(value="userInterceptor") ChannelInterceptor userInterceptor, @Autowired WebSocketsConfiguration webSocketsConfiguration, @Autowired ClientConfiguration clientConfiguration) {
        this.ciRefsJsonWriter = ciRefsJsonWriter;
        this.taskScheduler = taskScheduler;
        this.userInterceptor = userInterceptor;
        this.clientConfiguration = clientConfiguration;
        this.inputBufferSize = webSocketsConfiguration.messageBroker().inputBufferSize();
    }
}

