package com.xebialabs.deployit.core.rest.json

import java.io.{IOException, OutputStream, OutputStreamWriter}
import java.lang.annotation.Annotation
import java.lang.reflect.Type
import java.util

import com.xebialabs.deployit.core.api.dto.{ActiveUserSession}
import com.xebialabs.xltype.serialization.json.JsonWriter
import javax.ws.rs.core.{MediaType, MultivaluedMap}
import javax.ws.rs.ext.{MessageBodyWriter, Provider}
import javax.ws.rs.{Produces, WebApplicationException}
import org.springframework.stereotype.Component

@Component
@Provider
@Produces(Array(MediaType.APPLICATION_JSON))
class ActiveUserSessionScalaJsonWriter extends MessageBodyWriter[util.Collection[ActiveUserSession]] {

  private val helper = new JsonWriterHelper

  override def isWriteable(`type`: Class[_], genericType: Type, annotations: Array[Annotation],
                           mediaType: MediaType): Boolean = classOf[ActiveUserSession].isAssignableFrom(helper.getType(`type`, genericType))

  override def getSize(viewList: util.Collection[ActiveUserSession], `type`: Class[_], genericType: Type, annotations: Array[Annotation],
                       mediaType: MediaType): Long = -1

  @throws[IOException]
  @throws[WebApplicationException]
  override def writeTo(viewList: util.Collection[ActiveUserSession], `type`: Class[_], genericType: Type, annotations: Array[Annotation],
                       mediaType: MediaType, httpHeaders: MultivaluedMap[String, AnyRef],
                       entityStream: OutputStream): Unit = {
    val reportStreamWriter: OutputStreamWriter = new OutputStreamWriter(entityStream)
    writeJson(viewList, new JsonWriter(reportStreamWriter))
    reportStreamWriter.flush()
  }

  private def writeJson(viewList: util.Collection[ActiveUserSession], writer: JsonWriter): Unit = {
    writer.array
    viewList.forEach(view => {
      writer.`object`()
      writer.key("username").value(view.getUsername)
      writer.key("internal").value(view.isInternal)
      writer.key("controlTasks").value(view.getControlTasks)
      writer.key("deploymentTasks").value(view.getDeploymentTasks)
      writer.endObject()
    })
    writer.endArray
  }
}
