/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports.widgets;

import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.api.dto.ReportLine;
import com.xebialabs.deployit.core.rest.api.reports.widgets.DashboardWidgetBase;
import com.xebialabs.deployit.core.util.CiUtils;
import com.xebialabs.deployit.task.archive.TaskArchive;
import com.xebialabs.deployit.task.archive.TopNLongestRunningReportLine;
import java.util.Collection;
import org.joda.time.DateTime;

public class Top10LongestRunningDeployments
extends DashboardWidgetBase {
    private static final String DURATION = "duration";
    private static final String ENVIRONMENT = "environment";
    private static final String APPLICATION_NAME = "application";

    Top10LongestRunningDeployments(TaskArchive taskArchive) {
        super(taskArchive);
    }

    @Override
    public Report getReport(DateTime beginDate, DateTime endDate) {
        Collection searchResult = this.taskArchive.topNLongestRunningDeployments(beginDate, endDate, 10);
        return this.generateDurationReport(searchResult);
    }

    private Report generateDurationReport(Collection<TopNLongestRunningReportLine> resultList) {
        Report report = new Report();
        resultList.forEach(rs -> {
            ReportLine reportLine = report.addLine();
            reportLine.addValue(APPLICATION_NAME, (Object)rs.application());
            reportLine.addValue(ENVIRONMENT, (Object)CiUtils.getIdWithoutRoot((String)rs.environment()));
            reportLine.addValue(DURATION, (Object)Top10LongestRunningDeployments.formatToMinsAndSecs(rs.durationMillis()));
        });
        return report;
    }
}

