/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import akka.actor.ActorRef;
import akka.actor.AddressFromURIString$;
import akka.pattern.AskableActorRef$;
import akka.util.Timeout;
import com.xebialabs.deployit.converter.HoconDurationConverter$;
import com.xebialabs.deployit.core.api.WorkersService;
import com.xebialabs.deployit.core.api.dto.WorkerInfo;
import com.xebialabs.deployit.core.rest.api.WorkerState$;
import com.xebialabs.deployit.core.rest.api.WorkersSorting$;
import com.xebialabs.deployit.core.rest.api.support.PaginationSupport$;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.engine.api.distribution.TaskExecutionWorkerRepository;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.engine.api.dto.Worker;
import com.xebialabs.deployit.engine.tasker.TaskExecutionEngine;
import com.xebialabs.deployit.engine.tasker.distribution.WorkerManager;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.spring.BeanWrapper;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.stream.Collectors;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Context;
import org.jboss.resteasy.spi.HttpResponse;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import scala.Enumeration;
import scala.Function$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@Controller
@ScalaSignature(bytes="\u0006\u0005\u0005-h\u0001B\t\u0013\u0001}A\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\t/\u0002\u0011\t\u0011)A\u00051\"Aa\f\u0001B\u0001B\u0003%!\r\u0003\u0005k\u0001\t\u0005\t\u0015!\u0003l\u0011\u0015q\b\u0001\"\u0001\u0000\u0011%\t9\u0002\u0001b\u0001\n\u0017\tI\u0002\u0003\u0005\u0002(\u0001\u0001\u000b\u0011BA\u000e\u0011%\tI\u0003\u0001b\u0001\n\u0003\tY\u0003\u0003\u0005\u0002B\u0001\u0001\u000b\u0011BA\u0017\u0011\u001d\tY\u0006\u0001C!\u0003;Bq!!\u001f\u0001\t\u0003\nY\bC\u0004\u0002\u000e\u0002!I!a$\t\u000f\u0005m\u0005\u0001\"\u0003\u0002\u001e\"9\u0011\u0011\u0016\u0001\u0005B\u0005-\u0006bBAX\u0001\u0011\u0005\u0013\u0011\u0017\u0005\b\u0003g\u0003A\u0011IA[\u0005=9vN]6feN\u0014Vm]8ve\u000e,'BA\n\u0015\u0003\r\t\u0007/\u001b\u0006\u0003+Y\tAA]3ti*\u0011q\u0003G\u0001\u0005G>\u0014XM\u0003\u0002\u001a5\u0005AA-\u001a9m_fLGO\u0003\u0002\u001c9\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002;\u0005\u00191m\\7\u0004\u0001M!\u0001\u0001\t\u0014,!\t\tC%D\u0001#\u0015\t\u0019C#A\u0004tK\u000e,(/\u001a3\n\u0005\u0015\u0012#aF!cgR\u0014\u0018m\u0019;TK\u000e,(/\u001a3SKN|WO]2f!\t9\u0013&D\u0001)\u0015\t\u0019b#\u0003\u0002+Q\tqqk\u001c:lKJ\u001c8+\u001a:wS\u000e,\u0007C\u0001\u00172\u001b\u0005i#B\u0001\u00180\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005\u0001\u0014\u0001C4sSjTH.\u001a3\n\u0005Ij#a\u0002'pO\u001eLgnZ\u0001\u000eo>\u00148.\u001a:NC:\fw-\u001a:\u0011\u0007UB$(D\u00017\u0015\t9\u0004$\u0001\u0004taJLgnZ\u0005\u0003sY\u00121BQ3b]^\u0013\u0018\r\u001d9feB\u00111\bQ\u0007\u0002y)\u0011QHP\u0001\u0006C\u000e$xN\u001d\u0006\u0002\u007f\u0005!\u0011m[6b\u0013\t\tEH\u0001\u0005BGR|'OU3gQ\u0011\t1)\u0015*\u0011\u0005\u0011{U\"A#\u000b\u0005\u0019;\u0015AC1o]>$\u0018\r^5p]*\u0011\u0001*S\u0001\bM\u0006\u001cGo\u001c:z\u0015\tQ5*A\u0003cK\u0006t7O\u0003\u0002M\u001b\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001O\u0003\ry'oZ\u0005\u0003!\u0016\u0013\u0011\"U;bY&4\u0017.\u001a:\u0002\u000bY\fG.^3\"\u0003MB#!\u0001+\u0011\u0005\u0011+\u0016B\u0001,F\u0005%\tU\u000f^8xSJ,G-\u0001\tx_J\\WM\u001d*fa>\u001c\u0018\u000e^8ssB\u0011\u0011lX\u0007\u00025*\u00111\fX\u0001\rI&\u001cHO]5ckRLwN\u001c\u0006\u0003'uS!A\u0018\r\u0002\r\u0015tw-\u001b8f\u0013\t\u0001'LA\u000fUCN\\W\t_3dkRLwN\\,pe.,'OU3q_NLGo\u001c:zQ\t\u0011A\u000bE\u00026q\r\u0004\"\u0001Z4\u000e\u0003\u0015T!AZ/\u0002\rQ\f7o[3s\u0013\tAWMA\nUCN\\W\t_3dkRLwN\\#oO&tW\r\u000b\u0002\u0004)\u0006Q\u0011m]6US6,w.\u001e;\u0011\u00051,hBA7t!\tq\u0017/D\u0001p\u0015\t\u0001h$\u0001\u0004=e>|GO\u0010\u0006\u0002e\u0006)1oY1mC&\u0011A/]\u0001\u0007!J,G-\u001a4\n\u0005Y<(AB*ue&twM\u0003\u0002uc\"\"A!_)}!\t!%0\u0003\u0002|\u000b\n)a+\u00197vK\u0006\nQ0\u0001\u0012%wbdg\u0006^1tW\u0016\u0014h&Y:l)&lWm\\;uuE\u0002\u0004e]3d_:$7/`\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0015\u0005\u0005\u0011QAA\u0006\u0003\u001f\t\u0019\u0002E\u0002\u0002\u0004\u0001i\u0011A\u0005\u0005\u0006g\u0015\u0001\r\u0001\u000e\u0015\u0006\u0003\u000b\u0019\u0015K\u0015\u0015\u0004\u0003\u000b!\u0006\"B,\u0006\u0001\u0004A\u0006fAA\u0006)\")a,\u0002a\u0001E\"\u001a\u0011q\u0002+\t\u000b),\u0001\u0019A6)\u000b\u0005M\u00110\u0015?\u0002\u000fQLW.Z8viV\u0011\u00111\u0004\t\u0005\u0003;\t\u0019#\u0004\u0002\u0002 )\u0019\u0011\u0011\u0005 \u0002\tU$\u0018\u000e\\\u0005\u0005\u0003K\tyBA\u0004US6,w.\u001e;\u0002\u0011QLW.Z8vi\u0002\nA\u0002\u001b;uaJ+7\u000f]8og\u0016,\"!!\f\u0011\t\u0005=\u0012QH\u0007\u0003\u0003cQA!a\r\u00026\u0005\u00191\u000f]5\u000b\t\u0005]\u0012\u0011H\u0001\te\u0016\u001cH/Z1ts*\u0019\u00111H'\u0002\u000b)\u0014wn]:\n\t\u0005}\u0012\u0011\u0007\u0002\r\u0011R$\bOU3ta>t7/Z\u0001\u000eQR$\bOU3ta>t7/\u001a\u0011)\u0007%\t)\u0005\u0005\u0003\u0002H\u0005]SBAA%\u0015\r9\u00121\n\u0006\u0005\u0003\u001b\ny%\u0001\u0002sg*!\u0011\u0011KA*\u0003\t98O\u0003\u0002\u0002V\u0005)!.\u0019<bq&!\u0011\u0011LA%\u0005\u001d\u0019uN\u001c;fqR\fqb\u001d5vi\u0012|wO\\,pe.,'o\u001d\u000b\u0005\u0003?\n9\u0007\u0005\u0003\u0002b\u0005\rT\"A9\n\u0007\u0005\u0015\u0014O\u0001\u0003V]&$\bbBA5\u0015\u0001\u0007\u00111N\u0001\bo>\u00148.\u001a:t!\u0015\ti'!\u001el\u001b\t\tyG\u0003\u0003\u0002\"\u0005E$BAA:\u0003\u0011Q\u0017M^1\n\t\u0005]\u0014q\u000e\u0002\u0005\u0019&\u001cH/\u0001\btQV$Hm\\<o/>\u00148.\u001a:\u0015\t\u0005}\u0013Q\u0010\u0005\b\u0003\u007fZ\u0001\u0019AAA\u0003!9xN]6fe&#\u0007\u0003BAB\u0003\u0013k!!!\"\u000b\t\u0005\u001d\u0015\u0011O\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\f\u0006\u0015%aB%oi\u0016<WM]\u0001\u000eSNdunY1m/>\u00148.\u001a:\u0015\t\u0005E\u0015q\u0013\t\u0005\u0003C\n\u0019*C\u0002\u0002\u0016F\u0014qAQ8pY\u0016\fg\u000e\u0003\u0004\u0002\u001a2\u0001\ra[\u0001\bC\u0012$'/Z:t\u0003U!\bN]8x\u0019>\u001c\u0017\r\\,pe.,'/\u0012:s_J$B!a(\u0002&B!\u0011\u0011MAQ\u0013\r\t\u0019+\u001d\u0002\b\u001d>$\b.\u001b8h\u0011\u0019\t9+\u0004a\u0001W\u0006\t1/\u0001\u0007sK6|g/Z,pe.,'\u000f\u0006\u0003\u0002`\u00055\u0006bBA@\u001d\u0001\u0007\u0011\u0011Q\u0001\u0015e\u0016\u0014XmZ5ti\u0016\u0014x\t[8tiR\u000b7o[:\u0015\u0005\u0005-\u0014a\u00037jgR<vN]6feN$b!a.\u0002F\u0006M\u0007CBA7\u0003k\nI\f\u0005\u0003\u0002<\u0006\u0005WBAA_\u0015\r\ty\fK\u0001\u0004IR|\u0017\u0002BAb\u0003{\u0013!bV8sW\u0016\u0014\u0018J\u001c4p\u0011\u001d\t9\r\u0005a\u0001\u0003\u0013\fa\u0001]1hS:<\u0007\u0003BAf\u0003\u001fl!!!4\u000b\u0007\u0005}F,\u0003\u0003\u0002R\u00065'A\u0002)bO&tw\rC\u0004\u0002VB\u0001\r!a6\u0002\u000b=\u0014H-\u001a:\u0011\t\u0005-\u0017\u0011\\\u0005\u0005\u00037\fiM\u0001\u0005Pe\u0012,'/\u001b8hQ\r\u0001\u0011q\u001c\t\u0005\u0003C\f9/\u0004\u0002\u0002d*\u0019\u0011Q]&\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0002j\u0006\r(AC\"p]R\u0014x\u000e\u001c7fe\u0002")
public class WorkersResource
extends AbstractSecuredResource
implements WorkersService,
Logging {
    @Autowired
    @Qualifier(value="workerManager")
    private final BeanWrapper<ActorRef> workerManager;
    @Autowired
    private final TaskExecutionWorkerRepository workerRepository;
    @Autowired
    private final BeanWrapper<TaskExecutionEngine> engine;
    private final Timeout timeout;
    @Context
    private final HttpResponse httpResponse;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        WorkersResource workersResource = this;
        synchronized (workersResource) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    private Timeout timeout() {
        return this.timeout;
    }

    public HttpResponse httpResponse() {
        return this.httpResponse;
    }

    public void shutdownWorkers(java.util.List<String> workers) {
        this.checkPermission(PlatformPermissions.ADMIN);
        if (workers.isEmpty()) {
            this.logger().info((Function0 & Serializable)() -> "Shutting down all workers.");
        } else {
            this.logger().info((Function0 & Serializable)() -> new StringBuilder(23).append("Shutting down workers ").append(workers).append(".").toString());
        }
        CollectionConverters$.MODULE$.ListHasAsScala(workers).asScala().find((Function1 & Serializable)address -> BoxesRunTime.boxToBoolean((boolean)this.isLocalWorker(address))).foreach((Function1 & Serializable)s -> this.throwLocalWorkerError((String)s));
        this.workerRepository.listWorkers().map((Function1 & Serializable)x$1 -> (Worker)x$1._1()).foreach((Function1 & Serializable)worker -> {
            WorkersResource.$anonfun$shutdownWorkers$6(this, workers, worker);
            return BoxedUnit.UNIT;
        });
        ActorRef qual$1 = akka.pattern.package$.MODULE$.ask((ActorRef)this.workerManager.get());
        WorkerManager.messages$.ShutdownWorker x$12 = new WorkerManager.messages$.ShutdownWorker(CollectionConverters$.MODULE$.ListHasAsScala(workers).asScala().toList(), true);
        Timeout x$2 = this.timeout();
        ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$12);
        WorkerManager.messages$.WorkerShutdownStarted response = (WorkerManager.messages$.WorkerShutdownStarted)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension(qual$1, (Object)x$12, x$2, x$3), (Duration)this.timeout().duration());
        if (!workers.isEmpty()) {
            List shutdownWorkers = response.workers();
            this.logger().info((Function0 & Serializable)() -> new StringBuilder(18).append("Workers ").append(shutdownWorkers.mkString("[", ", ", "]")).append(" shutdown.").toString());
            ArrayList<String> notFound = new ArrayList<String>(workers);
            notFound.removeAll(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)shutdownWorkers).asJava());
            if (!notFound.isEmpty()) {
                throw new NotFoundException(new StringBuilder(40).append("Workers ").append(CollectionConverters$.MODULE$.ListHasAsScala(notFound).asScala().mkString("[", ", ", "]")).append(" not found. (Workers ").append(shutdownWorkers.mkString("[", ", ", "]")).append(" shutdown.)").toString());
            }
        }
    }

    public void shutdownWorker(Integer workerId) {
        this.checkPermission(PlatformPermissions.ADMIN);
        this.workerRepository.getWorker(workerId).orElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(25).append("Worker for id ").append(workerId).append(" not found.").toString());
        }).foreach((Function1 & Serializable)worker -> {
            WorkersResource.$anonfun$shutdownWorker$2(this, worker);
            return BoxedUnit.UNIT;
        });
    }

    private boolean isLocalWorker(String address) {
        return AddressFromURIString$.MODULE$.apply(address).hasLocalScope();
    }

    private Nothing$ throwLocalWorkerError(String s) {
        throw new IllegalArgumentException(new StringBuilder(35).append("Local worker (").append(s).append(") cannot be shutdown.").toString());
    }

    public void removeWorker(Integer workerId) {
        this.checkPermission(PlatformPermissions.ADMIN);
        this.workerRepository.getWorker(workerId).orElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(25).append("Worker for id ").append(workerId).append(" not found.").toString());
        }).foreach((Function1 & Serializable)worker -> {
            WorkersResource.$anonfun$removeWorker$2(this, workerId, worker);
            return BoxedUnit.UNIT;
        });
    }

    public java.util.List<String> reregisterGhostTasks() {
        this.checkPermission(PlatformPermissions.ADMIN);
        return ((TaskExecutionEngine)this.engine.get()).reregisterGhostTasks();
    }

    public java.util.List<WorkerInfo> listWorkers(Paging paging, com.xebialabs.deployit.engine.api.dto.Ordering order) {
        java.util.List list;
        this.checkPermission(PlatformPermissions.ADMIN);
        Timeout timeout = new Timeout(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).seconds());
        ActorRef qual$1 = akka.pattern.package$.MODULE$.ask((ActorRef)this.workerManager.get());
        WorkerManager.messages$.FetchWorkers x$1 = new WorkerManager.messages$.FetchWorkers();
        Timeout x$22 = timeout;
        ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
        WorkerManager.messages.WorkersFetched response = (WorkerManager.messages.WorkersFetched)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension(qual$1, (Object)x$1, x$22, x$3), (Duration)timeout.duration());
        List workers = this.workerRepository.listWorkers().map(Function$.MODULE$.tupled((Function3 & Serializable)(w, deploymentTasks, controlTasks) -> new WorkerInfo(Predef$.MODULE$.Integer2int(w.id()), w.name(), w.address(), WorkersResource.calculateState$1(w, response.healthy(), response.incompatible(), response.draining()).toString(), Predef$.MODULE$.Integer2int(deploymentTasks), Predef$.MODULE$.Integer2int(controlTasks))));
        if ((paging == null || paging.resultsPerPage() == -1) && order == null) {
            list = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)workers.sortBy((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.getId()), (Ordering)Ordering.Int$.MODULE$)).asJava().stream().collect(Collectors.toList());
        } else {
            PaginationSupport$.MODULE$.addTotalCountHeader((long)workers.size(), this.httpResponse());
            int from = (paging.page() - 1) * paging.resultsPerPage();
            int to = from + paging.resultsPerPage() <= CollectionConverters$.MODULE$.SeqHasAsJava((Seq)workers).asJava().size() ? from + paging.resultsPerPage() : CollectionConverters$.MODULE$.SeqHasAsJava((Seq)workers).asJava().size();
            list = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)WorkersSorting$.MODULE$.sort((List<WorkerInfo>)workers, order).slice(from, to)).asJava();
        }
        return list;
    }

    public static final /* synthetic */ void $anonfun$shutdownWorkers$6(WorkersResource $this, java.util.List workers$1, Worker worker) {
        block0: {
            if (!workers$1.isEmpty() && !workers$1.contains(worker.address())) break block0;
            $this.workerRepository.removeTasks(worker.id());
        }
    }

    public static final /* synthetic */ void $anonfun$shutdownWorker$2(WorkersResource $this, Worker worker) {
        String address = worker.address();
        if ($this.isLocalWorker(address)) {
            throw $this.throwLocalWorkerError(address);
        }
        ActorRef qual$1 = akka.pattern.package$.MODULE$.ask((ActorRef)$this.workerManager.get());
        WorkerManager.messages$.ShutdownWorker x$1 = new WorkerManager.messages$.ShutdownWorker((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{address})), false);
        Timeout x$2 = $this.timeout();
        ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
        WorkerManager.messages$.WorkerShutdownStarted response = (WorkerManager.messages$.WorkerShutdownStarted)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension(qual$1, (Object)x$1, x$2, x$3), (Duration)$this.timeout().duration());
        List shutdownWorkers = response.workers();
        $this.logger().info((Function0 & Serializable)() -> new StringBuilder(18).append("Workers ").append(shutdownWorkers.mkString("[", ", ", "]")).append(" shutdown.").toString());
        if (!response.workers().contains((Object)address)) {
            throw new NotFoundException(new StringBuilder(18).append("Worker ").append(address).append(" not found.").toString());
        }
    }

    public static final /* synthetic */ void $anonfun$removeWorker$2(WorkersResource $this, Integer workerId$2, Worker worker) {
        ActorRef x$3;
        Timeout x$2;
        WorkerManager.messages$.FetchWorkers x$1;
        ActorRef qual$1 = akka.pattern.package$.MODULE$.ask((ActorRef)$this.workerManager.get());
        WorkerManager.messages.WorkersFetched response = (WorkerManager.messages.WorkersFetched)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension(qual$1, (Object)(x$1 = new WorkerManager.messages$.FetchWorkers()), x$2 = $this.timeout(), x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1)), (Duration)$this.timeout().duration());
        List active = (List)response.draining().$plus$plus((IterableOnce)response.healthy());
        if (active.contains((Object)worker.address())) {
            throw new IllegalArgumentException(new StringBuilder(50).append("Worker for id ").append(workerId$2).append(" is still active, cannot be removed.").toString());
        }
        $this.workerRepository.removeTasks(workerId$2);
        $this.workerRepository.removeWorker(workerId$2);
    }

    private static final Enumeration.Value calculateState$1(Worker w, List healthy, List incompatible, List draining) {
        return healthy.contains((Object)w.address()) ? WorkerState$.MODULE$.CONNECTED() : (incompatible.contains((Object)w.address()) ? WorkerState$.MODULE$.INCOMPATIBLE() : (draining.contains((Object)w.address()) ? WorkerState$.MODULE$.DRAINING() : WorkerState$.MODULE$.DISCONNECTED()));
    }

    public WorkersResource(@Autowired @Qualifier(value="workerManager") BeanWrapper<ActorRef> workerManager, @Autowired TaskExecutionWorkerRepository workerRepository, @Autowired BeanWrapper<TaskExecutionEngine> engine, @Value(value="${xl.tasker.askTimeout:10 seconds}") String askTimeout) {
        this.workerManager = workerManager;
        this.workerRepository = workerRepository;
        this.engine = engine;
        Logging.$init$((Logging)this);
        this.timeout = new Timeout(HoconDurationConverter$.MODULE$.convert(askTimeout));
        this.httpResponse = null;
    }
}

