package com.xebialabs.deployit.core.service;

import com.xebialabs.deployit.engine.api.dto.Paging;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.function.BiConsumer;
import java.util.function.Supplier;

@Service
public class PaginationService {
    private static final Logger log = LoggerFactory.getLogger(PaginationService.class);

    @Value("${xl.rest.api.maxPageSize:1000}")
    private Integer maxPageSize;

    public Paging getLimitedPaging(Paging input) {
        // Limit the pagination size
        if (input.resultsPerPage() <= 0 || input.resultsPerPage() > maxPageSize) {
            return new Paging(input.page(), maxPageSize);
        }
        return input;
    }

    public void addPagingHeaderIfNeeded(BiConsumer<String, Object> setHeader, Supplier<Integer> countTotalResults, Paging paging) {
        Paging limited = getLimitedPaging(paging);
        addPagingHeaderIfNeeded(paging, limited, setHeader, countTotalResults);
    }

    public void addPagingHeaderIfNeeded(Paging paging, Paging limited, BiConsumer<String, Object> setHeader, Supplier<Integer> countTotalResults) {
        if (limited.resultsPerPage() > 0) {
            int count = countTotalResults.get();
            if (paging.resultsPerPage() <= 0 && count > limited.resultsPerPage()) {
                log.warn("Limiting total number of results {} to maximum {}", count, limited.resultsPerPage());
            }
            setHeader.accept(Paging.X_TOTAL_COUNT_HEADER(), count);
        }
    }

    public BiConsumer<String, Object> toSetHeader(HttpResponse response) {
        if (ResteasyProviderFactory.getInstance().getContextData(HttpResponse.class) != null) {
            return response.getOutputHeaders()::putSingle;
        }
        return new IgnoreNoHttpResponseContext();
    }

    private static class IgnoreNoHttpResponseContext implements BiConsumer<String, Object> {
        @Override
        public void accept(String s, Object o) {

        }
    }

    public void setMaxPageSize(Integer maxPageSize) {
        this.maxPageSize = maxPageSize;
    }
}
