package com.xebialabs.deployit.core.server.service

import com.xebialabs.deployit.ServerConfiguration
import com.xebialabs.deployit.engine.spi.event.{SpringInstantiatedListener, SystemStartedEvent}
import nl.javadude.t2bus.Subscribe
import org.jboss.resteasy.util.HttpHeaderNames
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.http.MediaType
import org.springframework.stereotype.Component

import java.net.URI
import java.net.http.HttpRequest.BodyPublishers
import java.net.http.HttpResponse.BodyHandlers
import java.net.http.{HttpClient, HttpRequest}
import java.time.Duration

@Component
class ConfigurationRefreshServiceImpl extends ConfigurationRefreshService {

  @Autowired
  var serverConfiguration: ServerConfiguration = _

  override def refreshCentralConfiguration(): Unit = {
    val client = HttpClient.newBuilder.build
    val request = HttpRequest.newBuilder()
      .uri(URI.create(s"${serverConfiguration.getServerUrl}actuator/refresh"))
      .timeout(Duration.ofMinutes(1))
      .header(HttpHeaderNames.CONTENT_TYPE, MediaType.APPLICATION_JSON_VALUE)
      .POST(BodyPublishers.ofString(""))
      .build()
    client.send(request, BodyHandlers.discarding())
  }
}
